/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Identifying information for transferring holdings to an investments account via ACATS.")
public class NumbersACATS {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private String account;
    public static final String SERIALIZED_NAME_DTC_NUMBERS = "dtc_numbers";
    @SerializedName(value="dtc_numbers")
    private List<String> dtcNumbers = new ArrayList<String>();

    public NumbersACATS accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid account ID associated with the account numbers")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public NumbersACATS account(String account) {
        this.account = account;
        return this;
    }

    @ApiModelProperty(required=true, value="The full account number for the account")
    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public NumbersACATS dtcNumbers(List<String> dtcNumbers) {
        this.dtcNumbers = dtcNumbers;
        return this;
    }

    public NumbersACATS addDtcNumbersItem(String dtcNumbersItem) {
        this.dtcNumbers.add(dtcNumbersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Identifiers for the clearinghouses that are assocciated with the account in order of relevance. This array will be empty if we can't provide any account level data. Institution level data can be retrieved from the institutions/get endpoints.")
    public List<String> getDtcNumbers() {
        return this.dtcNumbers;
    }

    public void setDtcNumbers(List<String> dtcNumbers) {
        this.dtcNumbers = dtcNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumbersACATS numbersACATS = (NumbersACATS)o;
        return Objects.equals(this.accountId, numbersACATS.accountId) && Objects.equals(this.account, numbersACATS.account) && Objects.equals(this.dtcNumbers, numbersACATS.dtcNumbers);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.account, this.dtcNumbers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NumbersACATS {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    dtcNumbers: ").append(this.toIndentedString(this.dtcNumbers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

