/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Identifying information for transferring money to or from a US account via ACH or wire transfer.")
public class NumbersACH {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private String account;
    public static final String SERIALIZED_NAME_ROUTING = "routing";
    @SerializedName(value="routing")
    private String routing;
    public static final String SERIALIZED_NAME_WIRE_ROUTING = "wire_routing";
    @SerializedName(value="wire_routing")
    private String wireRouting;
    public static final String SERIALIZED_NAME_CAN_TRANSFER_IN = "can_transfer_in";
    @SerializedName(value="can_transfer_in")
    private Boolean canTransferIn;
    public static final String SERIALIZED_NAME_CAN_TRANSFER_OUT = "can_transfer_out";
    @SerializedName(value="can_transfer_out")
    private Boolean canTransferOut;

    public NumbersACH accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid account ID associated with the account numbers")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public NumbersACH account(String account) {
        this.account = account;
        return this;
    }

    @ApiModelProperty(required=true, value="The ACH account number for the account.  Note that when using OAuth with Chase Bank (`ins_56`), Chase will issue \"tokenized\" routing and account numbers, which are not the user's actual account and routing numbers. These tokenized account numbers (also known as TANs) should work identically to normal account and routing numbers. The digits returned in the `mask` field will continue to reflect the actual account number, rather than the tokenized account number; for this reason, when displaying account numbers to the user to help them identify their account in your UI, always use the `mask` rather than truncating the `account` number. If a user revokes their permissions to your app, the tokenized numbers will no longer work.")
    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public NumbersACH routing(String routing) {
        this.routing = routing;
        return this;
    }

    @ApiModelProperty(required=true, value="The ACH routing number for the account. If the institution is `ins_56`, this may be a tokenized routing number. For more information, see the description of the `account` field.")
    public String getRouting() {
        return this.routing;
    }

    public void setRouting(String routing) {
        this.routing = routing;
    }

    public NumbersACH wireRouting(String wireRouting) {
        this.wireRouting = wireRouting;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The wire transfer routing number for the account, if available")
    public String getWireRouting() {
        return this.wireRouting;
    }

    public void setWireRouting(String wireRouting) {
        this.wireRouting = wireRouting;
    }

    public NumbersACH canTransferIn(Boolean canTransferIn) {
        this.canTransferIn = canTransferIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the account supports ACH transfers into the account")
    public Boolean getCanTransferIn() {
        return this.canTransferIn;
    }

    public void setCanTransferIn(Boolean canTransferIn) {
        this.canTransferIn = canTransferIn;
    }

    public NumbersACH canTransferOut(Boolean canTransferOut) {
        this.canTransferOut = canTransferOut;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the account supports ACH transfers out of the account")
    public Boolean getCanTransferOut() {
        return this.canTransferOut;
    }

    public void setCanTransferOut(Boolean canTransferOut) {
        this.canTransferOut = canTransferOut;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumbersACH numbersACH = (NumbersACH)o;
        return Objects.equals(this.accountId, numbersACH.accountId) && Objects.equals(this.account, numbersACH.account) && Objects.equals(this.routing, numbersACH.routing) && Objects.equals(this.wireRouting, numbersACH.wireRouting) && Objects.equals(this.canTransferIn, numbersACH.canTransferIn) && Objects.equals(this.canTransferOut, numbersACH.canTransferOut);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.account, this.routing, this.wireRouting, this.canTransferIn, this.canTransferOut);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NumbersACH {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    routing: ").append(this.toIndentedString(this.routing)).append("\n");
        sb.append("    wireRouting: ").append(this.toIndentedString(this.wireRouting)).append("\n");
        sb.append("    canTransferIn: ").append(this.toIndentedString(this.canTransferIn)).append("\n");
        sb.append("    canTransferOut: ").append(this.toIndentedString(this.canTransferOut)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

