/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Identifying information for transferring money to or from a UK bank account via BACS.")
public class NumbersBACSNullable {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private String account;
    public static final String SERIALIZED_NAME_SORT_CODE = "sort_code";
    @SerializedName(value="sort_code")
    private String sortCode;

    public NumbersBACSNullable accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid account ID associated with the account numbers")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public NumbersBACSNullable account(String account) {
        this.account = account;
        return this;
    }

    @ApiModelProperty(required=true, value="The BACS account number for the account")
    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public NumbersBACSNullable sortCode(String sortCode) {
        this.sortCode = sortCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The BACS sort code for the account")
    public String getSortCode() {
        return this.sortCode;
    }

    public void setSortCode(String sortCode) {
        this.sortCode = sortCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumbersBACSNullable numbersBACSNullable = (NumbersBACSNullable)o;
        return Objects.equals(this.accountId, numbersBACSNullable.accountId) && Objects.equals(this.account, numbersBACSNullable.account) && Objects.equals(this.sortCode, numbersBACSNullable.sortCode);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.account, this.sortCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NumbersBACSNullable {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    sortCode: ").append(this.toIndentedString(this.sortCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

