/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Identifying information for transferring money to or from a Canadian bank account via EFT.")
public class NumbersEFTNullable {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private String account;
    public static final String SERIALIZED_NAME_INSTITUTION = "institution";
    @SerializedName(value="institution")
    private String institution;
    public static final String SERIALIZED_NAME_BRANCH = "branch";
    @SerializedName(value="branch")
    private String branch;

    public NumbersEFTNullable accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid account ID associated with the account numbers")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public NumbersEFTNullable account(String account) {
        this.account = account;
        return this;
    }

    @ApiModelProperty(required=true, value="The EFT account number for the account")
    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public NumbersEFTNullable institution(String institution) {
        this.institution = institution;
        return this;
    }

    @ApiModelProperty(required=true, value="The EFT institution number for the account")
    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    public NumbersEFTNullable branch(String branch) {
        this.branch = branch;
        return this;
    }

    @ApiModelProperty(required=true, value="The EFT branch number for the account")
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumbersEFTNullable numbersEFTNullable = (NumbersEFTNullable)o;
        return Objects.equals(this.accountId, numbersEFTNullable.accountId) && Objects.equals(this.account, numbersEFTNullable.account) && Objects.equals(this.institution, numbersEFTNullable.institution) && Objects.equals(this.branch, numbersEFTNullable.branch);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.account, this.institution, this.branch);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NumbersEFTNullable {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    institution: ").append(this.toIndentedString(this.institution)).append("\n");
        sb.append("    branch: ").append(this.toIndentedString(this.branch)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

