/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Account numbers using the International Bank Account Number and BIC/SWIFT code format.")
public class NumbersInternationalIBAN {
    public static final String SERIALIZED_NAME_IBAN = "iban";
    @SerializedName(value="iban")
    private String iban;
    public static final String SERIALIZED_NAME_BIC = "bic";
    @SerializedName(value="bic")
    private String bic;

    public NumbersInternationalIBAN iban(String iban) {
        this.iban = iban;
        return this;
    }

    @ApiModelProperty(required=true, value="International Bank Account Number (IBAN).")
    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public NumbersInternationalIBAN bic(String bic) {
        this.bic = bic;
        return this;
    }

    @ApiModelProperty(required=true, value="The Business Identifier Code, also known as SWIFT code, for this bank account.")
    public String getBic() {
        return this.bic;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumbersInternationalIBAN numbersInternationalIBAN = (NumbersInternationalIBAN)o;
        return Objects.equals(this.iban, numbersInternationalIBAN.iban) && Objects.equals(this.bic, numbersInternationalIBAN.bic);
    }

    public int hashCode() {
        return Objects.hash(this.iban, this.bic);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NumbersInternationalIBAN {\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    bic: ").append(this.toIndentedString(this.bic)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

