/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Identifying information for transferring money to or from an international bank account via wire transfer.")
public class NumbersInternationalNullable {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_IBAN = "iban";
    @SerializedName(value="iban")
    private String iban;
    public static final String SERIALIZED_NAME_BIC = "bic";
    @SerializedName(value="bic")
    private String bic;

    public NumbersInternationalNullable accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid account ID associated with the account numbers")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public NumbersInternationalNullable iban(String iban) {
        this.iban = iban;
        return this;
    }

    @ApiModelProperty(required=true, value="The International Bank Account Number (IBAN) for the account")
    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public NumbersInternationalNullable bic(String bic) {
        this.bic = bic;
        return this;
    }

    @ApiModelProperty(required=true, value="The Bank Identifier Code (BIC) for the account")
    public String getBic() {
        return this.bic;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumbersInternationalNullable numbersInternationalNullable = (NumbersInternationalNullable)o;
        return Objects.equals(this.accountId, numbersInternationalNullable.accountId) && Objects.equals(this.iban, numbersInternationalNullable.iban) && Objects.equals(this.bic, numbersInternationalNullable.bic);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.iban, this.bic);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NumbersInternationalNullable {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    bic: ").append(this.toIndentedString(this.bic)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

