/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;

@ApiModel(description="Details about the option security.  For the Sandbox environment, this data is currently only available if the item is using a custom configuration object, and the `ticker` field of the custom security follows the [OCC Option Symbol](https://en.wikipedia.org/wiki/Option_symbol#The_OCC_Option_Symbol) standard with no spaces.")
public class OptionContract {
    public static final String SERIALIZED_NAME_CONTRACT_TYPE = "contract_type";
    @SerializedName(value="contract_type")
    private String contractType;
    public static final String SERIALIZED_NAME_EXPIRATION_DATE = "expiration_date";
    @SerializedName(value="expiration_date")
    private LocalDate expirationDate;
    public static final String SERIALIZED_NAME_STRIKE_PRICE = "strike_price";
    @SerializedName(value="strike_price")
    private Double strikePrice;
    public static final String SERIALIZED_NAME_UNDERLYING_SECURITY_TICKER = "underlying_security_ticker";
    @SerializedName(value="underlying_security_ticker")
    private String underlyingSecurityTicker;

    public OptionContract contractType(String contractType) {
        this.contractType = contractType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of this option contract. It is one of:  `put`: for Put option contracts  `call`: for Call option contracts")
    public String getContractType() {
        return this.contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public OptionContract expirationDate(LocalDate expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The expiration date for this option contract, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.")
    public LocalDate getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(LocalDate expirationDate) {
        this.expirationDate = expirationDate;
    }

    public OptionContract strikePrice(Double strikePrice) {
        this.strikePrice = strikePrice;
        return this;
    }

    @ApiModelProperty(required=true, value="The strike price for this option contract, per share of security.")
    public Double getStrikePrice() {
        return this.strikePrice;
    }

    public void setStrikePrice(Double strikePrice) {
        this.strikePrice = strikePrice;
    }

    public OptionContract underlyingSecurityTicker(String underlyingSecurityTicker) {
        this.underlyingSecurityTicker = underlyingSecurityTicker;
        return this;
    }

    @ApiModelProperty(required=true, value="The ticker of the underlying security for this option contract.")
    public String getUnderlyingSecurityTicker() {
        return this.underlyingSecurityTicker;
    }

    public void setUnderlyingSecurityTicker(String underlyingSecurityTicker) {
        this.underlyingSecurityTicker = underlyingSecurityTicker;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionContract optionContract = (OptionContract)o;
        return Objects.equals(this.contractType, optionContract.contractType) && Objects.equals(this.expirationDate, optionContract.expirationDate) && Objects.equals(this.strikePrice, optionContract.strikePrice) && Objects.equals(this.underlyingSecurityTicker, optionContract.underlyingSecurityTicker);
    }

    public int hashCode() {
        return Objects.hash(this.contractType, this.expirationDate, this.strikePrice, this.underlyingSecurityTicker);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OptionContract {\n");
        sb.append("    contractType: ").append(this.toIndentedString(this.contractType)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    strikePrice: ").append(this.toIndentedString(this.strikePrice)).append("\n");
        sb.append("    underlyingSecurityTicker: ").append(this.toIndentedString(this.underlyingSecurityTicker)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

