/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountSubtype;
import com.plaid.client.model.HoldingsOverride;
import com.plaid.client.model.IncomeOverride;
import com.plaid.client.model.InflowModel;
import com.plaid.client.model.InvestmentsTransactionsOverride;
import com.plaid.client.model.LiabilityOverride;
import com.plaid.client.model.Meta;
import com.plaid.client.model.Numbers;
import com.plaid.client.model.OverrideAccountType;
import com.plaid.client.model.OwnerOverride;
import com.plaid.client.model.TransactionOverride;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Data to use to set values of test accounts. Some values cannot be specified in the schema and will instead will be calculated from other test data in order to achieve more consistent, realistic test data.")
public class OverrideAccounts {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private OverrideAccountType type;
    public static final String SERIALIZED_NAME_SUBTYPE = "subtype";
    @SerializedName(value="subtype")
    private AccountSubtype subtype;
    public static final String SERIALIZED_NAME_STARTING_BALANCE = "starting_balance";
    @SerializedName(value="starting_balance")
    private Double startingBalance;
    public static final String SERIALIZED_NAME_FORCE_AVAILABLE_BALANCE = "force_available_balance";
    @SerializedName(value="force_available_balance")
    private Double forceAvailableBalance;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_META = "meta";
    @SerializedName(value="meta")
    private Meta meta;
    public static final String SERIALIZED_NAME_NUMBERS = "numbers";
    @SerializedName(value="numbers")
    private Numbers numbers;
    public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
    @SerializedName(value="transactions")
    private List<TransactionOverride> transactions = new ArrayList<TransactionOverride>();
    public static final String SERIALIZED_NAME_HOLDINGS = "holdings";
    @SerializedName(value="holdings")
    private HoldingsOverride holdings;
    public static final String SERIALIZED_NAME_INVESTMENT_TRANSACTIONS = "investment_transactions";
    @SerializedName(value="investment_transactions")
    private InvestmentsTransactionsOverride investmentTransactions;
    public static final String SERIALIZED_NAME_IDENTITY = "identity";
    @SerializedName(value="identity")
    private OwnerOverride identity;
    public static final String SERIALIZED_NAME_LIABILITY = "liability";
    @SerializedName(value="liability")
    private LiabilityOverride liability;
    public static final String SERIALIZED_NAME_INFLOW_MODEL = "inflow_model";
    @SerializedName(value="inflow_model")
    private InflowModel inflowModel;
    public static final String SERIALIZED_NAME_INCOME = "income";
    @SerializedName(value="income")
    private IncomeOverride income;

    public OverrideAccounts type(OverrideAccountType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public OverrideAccountType getType() {
        return this.type;
    }

    public void setType(OverrideAccountType type) {
        this.type = type;
    }

    public OverrideAccounts subtype(AccountSubtype subtype) {
        this.subtype = subtype;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public AccountSubtype getSubtype() {
        return this.subtype;
    }

    public void setSubtype(AccountSubtype subtype) {
        this.subtype = subtype;
    }

    public OverrideAccounts startingBalance(Double startingBalance) {
        this.startingBalance = startingBalance;
        return this;
    }

    @ApiModelProperty(required=true, value="If provided, the account will start with this amount as the current balance. ")
    public Double getStartingBalance() {
        return this.startingBalance;
    }

    public void setStartingBalance(Double startingBalance) {
        this.startingBalance = startingBalance;
    }

    public OverrideAccounts forceAvailableBalance(Double forceAvailableBalance) {
        this.forceAvailableBalance = forceAvailableBalance;
        return this;
    }

    @ApiModelProperty(required=true, value="If provided, the account will always have this amount as its  available balance, regardless of current balance or changes in transactions over time.")
    public Double getForceAvailableBalance() {
        return this.forceAvailableBalance;
    }

    public void setForceAvailableBalance(Double forceAvailableBalance) {
        this.forceAvailableBalance = forceAvailableBalance;
    }

    public OverrideAccounts currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="ISO-4217 currency code. If provided, the account will be denominated in the given currency. Transactions will also be in this currency by default.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public OverrideAccounts meta(Meta meta) {
        this.meta = meta;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public OverrideAccounts numbers(Numbers numbers) {
        this.numbers = numbers;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Numbers getNumbers() {
        return this.numbers;
    }

    public void setNumbers(Numbers numbers) {
        this.numbers = numbers;
    }

    public OverrideAccounts transactions(List<TransactionOverride> transactions) {
        this.transactions = transactions;
        return this;
    }

    public OverrideAccounts addTransactionsItem(TransactionOverride transactionsItem) {
        this.transactions.add(transactionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Specify the list of transactions on the account.")
    public List<TransactionOverride> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<TransactionOverride> transactions) {
        this.transactions = transactions;
    }

    public OverrideAccounts holdings(HoldingsOverride holdings) {
        this.holdings = holdings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public HoldingsOverride getHoldings() {
        return this.holdings;
    }

    public void setHoldings(HoldingsOverride holdings) {
        this.holdings = holdings;
    }

    public OverrideAccounts investmentTransactions(InvestmentsTransactionsOverride investmentTransactions) {
        this.investmentTransactions = investmentTransactions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public InvestmentsTransactionsOverride getInvestmentTransactions() {
        return this.investmentTransactions;
    }

    public void setInvestmentTransactions(InvestmentsTransactionsOverride investmentTransactions) {
        this.investmentTransactions = investmentTransactions;
    }

    public OverrideAccounts identity(OwnerOverride identity) {
        this.identity = identity;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public OwnerOverride getIdentity() {
        return this.identity;
    }

    public void setIdentity(OwnerOverride identity) {
        this.identity = identity;
    }

    public OverrideAccounts liability(LiabilityOverride liability) {
        this.liability = liability;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public LiabilityOverride getLiability() {
        return this.liability;
    }

    public void setLiability(LiabilityOverride liability) {
        this.liability = liability;
    }

    public OverrideAccounts inflowModel(InflowModel inflowModel) {
        this.inflowModel = inflowModel;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public InflowModel getInflowModel() {
        return this.inflowModel;
    }

    public void setInflowModel(InflowModel inflowModel) {
        this.inflowModel = inflowModel;
    }

    public OverrideAccounts income(IncomeOverride income) {
        this.income = income;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IncomeOverride getIncome() {
        return this.income;
    }

    public void setIncome(IncomeOverride income) {
        this.income = income;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverrideAccounts overrideAccounts = (OverrideAccounts)o;
        return Objects.equals((Object)this.type, (Object)overrideAccounts.type) && Objects.equals((Object)this.subtype, (Object)overrideAccounts.subtype) && Objects.equals(this.startingBalance, overrideAccounts.startingBalance) && Objects.equals(this.forceAvailableBalance, overrideAccounts.forceAvailableBalance) && Objects.equals(this.currency, overrideAccounts.currency) && Objects.equals(this.meta, overrideAccounts.meta) && Objects.equals(this.numbers, overrideAccounts.numbers) && Objects.equals(this.transactions, overrideAccounts.transactions) && Objects.equals(this.holdings, overrideAccounts.holdings) && Objects.equals(this.investmentTransactions, overrideAccounts.investmentTransactions) && Objects.equals(this.identity, overrideAccounts.identity) && Objects.equals(this.liability, overrideAccounts.liability) && Objects.equals(this.inflowModel, overrideAccounts.inflowModel) && Objects.equals(this.income, overrideAccounts.income);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.subtype, this.startingBalance, this.forceAvailableBalance, this.currency, this.meta, this.numbers, this.transactions, this.holdings, this.investmentTransactions, this.identity, this.liability, this.inflowModel, this.income});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OverrideAccounts {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    subtype: ").append(this.toIndentedString((Object)this.subtype)).append("\n");
        sb.append("    startingBalance: ").append(this.toIndentedString(this.startingBalance)).append("\n");
        sb.append("    forceAvailableBalance: ").append(this.toIndentedString(this.forceAvailableBalance)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    numbers: ").append(this.toIndentedString(this.numbers)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("    holdings: ").append(this.toIndentedString(this.holdings)).append("\n");
        sb.append("    investmentTransactions: ").append(this.toIndentedString(this.investmentTransactions)).append("\n");
        sb.append("    identity: ").append(this.toIndentedString(this.identity)).append("\n");
        sb.append("    liability: ").append(this.toIndentedString(this.liability)).append("\n");
        sb.append("    inflowModel: ").append(this.toIndentedString(this.inflowModel)).append("\n");
        sb.append("    income: ").append(this.toIndentedString(this.income)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

