/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Address;
import com.plaid.client.model.Email;
import com.plaid.client.model.PhoneNumber;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Data returned from the financial institution about the owner or owners of an account. Only the `names` array must be non-empty.")
public class Owner {
    public static final String SERIALIZED_NAME_NAMES = "names";
    @SerializedName(value="names")
    private List<String> names = new ArrayList<String>();
    public static final String SERIALIZED_NAME_PHONE_NUMBERS = "phone_numbers";
    @SerializedName(value="phone_numbers")
    private List<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>();
    public static final String SERIALIZED_NAME_EMAILS = "emails";
    @SerializedName(value="emails")
    private List<Email> emails = new ArrayList<Email>();
    public static final String SERIALIZED_NAME_ADDRESSES = "addresses";
    @SerializedName(value="addresses")
    private List<Address> addresses = new ArrayList<Address>();

    public Owner names(List<String> names) {
        this.names = names;
        return this;
    }

    public Owner addNamesItem(String namesItem) {
        this.names.add(namesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of names associated with the account by the financial institution. In the case of a joint account, Plaid will make a best effort to report the names of all account holders.  If an Item contains multiple accounts with different owner names, some institutions will report all names associated with the Item in each account's `names` array.")
    public List<String> getNames() {
        return this.names;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public Owner phoneNumbers(List<PhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    public Owner addPhoneNumbersItem(PhoneNumber phoneNumbersItem) {
        this.phoneNumbers.add(phoneNumbersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of phone numbers associated with the account by the financial institution. May be an empty array if no relevant information is returned from the financial institution.")
    public List<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<PhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public Owner emails(List<Email> emails) {
        this.emails = emails;
        return this;
    }

    public Owner addEmailsItem(Email emailsItem) {
        this.emails.add(emailsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of email addresses associated with the account by the financial institution. May be an empty array if no relevant information is returned from the financial institution.")
    public List<Email> getEmails() {
        return this.emails;
    }

    public void setEmails(List<Email> emails) {
        this.emails = emails;
    }

    public Owner addresses(List<Address> addresses) {
        this.addresses = addresses;
        return this;
    }

    public Owner addAddressesItem(Address addressesItem) {
        this.addresses.add(addressesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Data about the various addresses associated with the account by the financial institution. May be an empty array if no relevant information is returned from the financial institution.")
    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Owner owner = (Owner)o;
        return Objects.equals(this.names, owner.names) && Objects.equals(this.phoneNumbers, owner.phoneNumbers) && Objects.equals(this.emails, owner.emails) && Objects.equals(this.addresses, owner.addresses);
    }

    public int hashCode() {
        return Objects.hash(this.names, this.phoneNumbers, this.emails, this.addresses);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Owner {\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("    phoneNumbers: ").append(this.toIndentedString(this.phoneNumbers)).append("\n");
        sb.append("    emails: ").append(this.toIndentedString(this.emails)).append("\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

