/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information about the student's eligibility in the Public Service Loan Forgiveness program. This is only returned if the institution is FedLoan (`ins_116527`). ")
public class PSLFStatus {
    public static final String SERIALIZED_NAME_ESTIMATED_ELIGIBILITY_DATE = "estimated_eligibility_date";
    @SerializedName(value="estimated_eligibility_date")
    private LocalDate estimatedEligibilityDate;
    public static final String SERIALIZED_NAME_PAYMENTS_MADE = "payments_made";
    @SerializedName(value="payments_made")
    private Integer paymentsMade;
    public static final String SERIALIZED_NAME_PAYMENTS_REMAINING = "payments_remaining";
    @SerializedName(value="payments_remaining")
    private Integer paymentsRemaining;

    public PSLFStatus estimatedEligibilityDate(LocalDate estimatedEligibilityDate) {
        this.estimatedEligibilityDate = estimatedEligibilityDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The estimated date borrower will have completed 120 qualifying monthly payments. Returned in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).")
    public LocalDate getEstimatedEligibilityDate() {
        return this.estimatedEligibilityDate;
    }

    public void setEstimatedEligibilityDate(LocalDate estimatedEligibilityDate) {
        this.estimatedEligibilityDate = estimatedEligibilityDate;
    }

    public PSLFStatus paymentsMade(Integer paymentsMade) {
        this.paymentsMade = paymentsMade;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The number of qualifying payments that have been made.")
    public Integer getPaymentsMade() {
        return this.paymentsMade;
    }

    public void setPaymentsMade(Integer paymentsMade) {
        this.paymentsMade = paymentsMade;
    }

    public PSLFStatus paymentsRemaining(Integer paymentsRemaining) {
        this.paymentsRemaining = paymentsRemaining;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The number of qualifying payments remaining.")
    public Integer getPaymentsRemaining() {
        return this.paymentsRemaining;
    }

    public void setPaymentsRemaining(Integer paymentsRemaining) {
        this.paymentsRemaining = paymentsRemaining;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PSLFStatus psLFStatus = (PSLFStatus)o;
        return Objects.equals(this.estimatedEligibilityDate, psLFStatus.estimatedEligibilityDate) && Objects.equals(this.paymentsMade, psLFStatus.paymentsMade) && Objects.equals(this.paymentsRemaining, psLFStatus.paymentsRemaining);
    }

    public int hashCode() {
        return Objects.hash(this.estimatedEligibilityDate, this.paymentsMade, this.paymentsRemaining);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PSLFStatus {\n");
        sb.append("    estimatedEligibilityDate: ").append(this.toIndentedString(this.estimatedEligibilityDate)).append("\n");
        sb.append("    paymentsMade: ").append(this.toIndentedString(this.paymentsMade)).append("\n");
        sb.append("    paymentsRemaining: ").append(this.toIndentedString(this.paymentsRemaining)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

