/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PartnerEndCustomerAddress;
import com.plaid.client.model.PartnerEndCustomerAssetsUnderManagement;
import com.plaid.client.model.PartnerEndCustomerBillingContact;
import com.plaid.client.model.PartnerEndCustomerCustomerSupportInfo;
import com.plaid.client.model.PartnerEndCustomerTechnicalContact;
import com.plaid.client.model.Products;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request schema for `/partner/customer/create`.")
public class PartnerCustomerCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_COMPANY_NAME = "company_name";
    @SerializedName(value="company_name")
    private String companyName;
    public static final String SERIALIZED_NAME_IS_DILIGENCE_ATTESTED = "is_diligence_attested";
    @SerializedName(value="is_diligence_attested")
    private Boolean isDiligenceAttested;
    public static final String SERIALIZED_NAME_PRODUCTS = "products";
    @SerializedName(value="products")
    private List<Products> products = null;
    public static final String SERIALIZED_NAME_CREATE_LINK_CUSTOMIZATION = "create_link_customization";
    @SerializedName(value="create_link_customization")
    private Boolean createLinkCustomization;
    public static final String SERIALIZED_NAME_LOGO = "logo";
    @SerializedName(value="logo")
    private String logo;
    public static final String SERIALIZED_NAME_LEGAL_ENTITY_NAME = "legal_entity_name";
    @SerializedName(value="legal_entity_name")
    private String legalEntityName;
    public static final String SERIALIZED_NAME_WEBSITE = "website";
    @SerializedName(value="website")
    private String website;
    public static final String SERIALIZED_NAME_APPLICATION_NAME = "application_name";
    @SerializedName(value="application_name")
    private String applicationName;
    public static final String SERIALIZED_NAME_TECHNICAL_CONTACT = "technical_contact";
    @SerializedName(value="technical_contact")
    private PartnerEndCustomerTechnicalContact technicalContact;
    public static final String SERIALIZED_NAME_BILLING_CONTACT = "billing_contact";
    @SerializedName(value="billing_contact")
    private PartnerEndCustomerBillingContact billingContact;
    public static final String SERIALIZED_NAME_CUSTOMER_SUPPORT_INFO = "customer_support_info";
    @SerializedName(value="customer_support_info")
    private PartnerEndCustomerCustomerSupportInfo customerSupportInfo;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private PartnerEndCustomerAddress address;
    public static final String SERIALIZED_NAME_IS_BANK_ADDENDUM_COMPLETED = "is_bank_addendum_completed";
    @SerializedName(value="is_bank_addendum_completed")
    private Boolean isBankAddendumCompleted;
    public static final String SERIALIZED_NAME_ASSETS_UNDER_MANAGEMENT = "assets_under_management";
    @SerializedName(value="assets_under_management")
    private PartnerEndCustomerAssetsUnderManagement assetsUnderManagement;
    public static final String SERIALIZED_NAME_REDIRECT_URIS = "redirect_uris";
    @SerializedName(value="redirect_uris")
    private List<String> redirectUris = null;
    public static final String SERIALIZED_NAME_REGISTRATION_NUMBER = "registration_number";
    @SerializedName(value="registration_number")
    private String registrationNumber;

    public PartnerCustomerCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public PartnerCustomerCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public PartnerCustomerCreateRequest companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @ApiModelProperty(required=true, value="The company name of the end customer being created. This will be used to display the end customer in the Plaid Dashboard. It will not be shown to end users.")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public PartnerCustomerCreateRequest isDiligenceAttested(Boolean isDiligenceAttested) {
        this.isDiligenceAttested = isDiligenceAttested;
        return this;
    }

    @ApiModelProperty(required=true, value="Denotes whether or not the partner has completed attestation of diligence for the end customer to be created.")
    public Boolean getIsDiligenceAttested() {
        return this.isDiligenceAttested;
    }

    public void setIsDiligenceAttested(Boolean isDiligenceAttested) {
        this.isDiligenceAttested = isDiligenceAttested;
    }

    public PartnerCustomerCreateRequest products(List<Products> products) {
        this.products = products;
        return this;
    }

    public PartnerCustomerCreateRequest addProductsItem(Products productsItem) {
        if (this.products == null) {
            this.products = new ArrayList<Products>();
        }
        this.products.add(productsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The products to be enabled for the end customer. If empty or `null`, this field will default to the products enabled for the reseller at the time this endpoint is called.")
    public List<Products> getProducts() {
        return this.products;
    }

    public void setProducts(List<Products> products) {
        this.products = products;
    }

    public PartnerCustomerCreateRequest createLinkCustomization(Boolean createLinkCustomization) {
        this.createLinkCustomization = createLinkCustomization;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If `true`, the end customer's default Link customization will be set to match the partner's. You can always change the end customer's Link customization in the Plaid Dashboard. See the [Link Customization docs](https://plaid.com/docs/link/customization/) for more information.")
    public Boolean getCreateLinkCustomization() {
        return this.createLinkCustomization;
    }

    public void setCreateLinkCustomization(Boolean createLinkCustomization) {
        this.createLinkCustomization = createLinkCustomization;
    }

    public PartnerCustomerCreateRequest logo(String logo) {
        this.logo = logo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Base64-encoded representation of the end customer's logo. Must be a PNG of size 1024x1024 under 4MB. The logo will be shared with financial institutions and shown to the end user during Link flows. A logo is required if `create_link_customization` is `true`. If `create_link_customization` is `false` and the logo is omitted, the partner's logo will be used if one exists, otherwise a stock logo will be used.")
    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public PartnerCustomerCreateRequest legalEntityName(String legalEntityName) {
        this.legalEntityName = legalEntityName;
        return this;
    }

    @ApiModelProperty(required=true, value="The end customer's legal name. This will be shared with financial institutions as part of the OAuth registration process. It will not be shown to end users.")
    public String getLegalEntityName() {
        return this.legalEntityName;
    }

    public void setLegalEntityName(String legalEntityName) {
        this.legalEntityName = legalEntityName;
    }

    public PartnerCustomerCreateRequest website(String website) {
        this.website = website;
        return this;
    }

    @ApiModelProperty(required=true, value="The end customer's website.")
    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public PartnerCustomerCreateRequest applicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the end customer's application. This will be shown to end users when they go through the Plaid Link flow.")
    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public PartnerCustomerCreateRequest technicalContact(PartnerEndCustomerTechnicalContact technicalContact) {
        this.technicalContact = technicalContact;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PartnerEndCustomerTechnicalContact getTechnicalContact() {
        return this.technicalContact;
    }

    public void setTechnicalContact(PartnerEndCustomerTechnicalContact technicalContact) {
        this.technicalContact = technicalContact;
    }

    public PartnerCustomerCreateRequest billingContact(PartnerEndCustomerBillingContact billingContact) {
        this.billingContact = billingContact;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PartnerEndCustomerBillingContact getBillingContact() {
        return this.billingContact;
    }

    public void setBillingContact(PartnerEndCustomerBillingContact billingContact) {
        this.billingContact = billingContact;
    }

    public PartnerCustomerCreateRequest customerSupportInfo(PartnerEndCustomerCustomerSupportInfo customerSupportInfo) {
        this.customerSupportInfo = customerSupportInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PartnerEndCustomerCustomerSupportInfo getCustomerSupportInfo() {
        return this.customerSupportInfo;
    }

    public void setCustomerSupportInfo(PartnerEndCustomerCustomerSupportInfo customerSupportInfo) {
        this.customerSupportInfo = customerSupportInfo;
    }

    public PartnerCustomerCreateRequest address(PartnerEndCustomerAddress address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PartnerEndCustomerAddress getAddress() {
        return this.address;
    }

    public void setAddress(PartnerEndCustomerAddress address) {
        this.address = address;
    }

    public PartnerCustomerCreateRequest isBankAddendumCompleted(Boolean isBankAddendumCompleted) {
        this.isBankAddendumCompleted = isBankAddendumCompleted;
        return this;
    }

    @ApiModelProperty(required=true, value="Denotes whether the partner has forwarded the Plaid bank addendum to the end customer.")
    public Boolean getIsBankAddendumCompleted() {
        return this.isBankAddendumCompleted;
    }

    public void setIsBankAddendumCompleted(Boolean isBankAddendumCompleted) {
        this.isBankAddendumCompleted = isBankAddendumCompleted;
    }

    public PartnerCustomerCreateRequest assetsUnderManagement(PartnerEndCustomerAssetsUnderManagement assetsUnderManagement) {
        this.assetsUnderManagement = assetsUnderManagement;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PartnerEndCustomerAssetsUnderManagement getAssetsUnderManagement() {
        return this.assetsUnderManagement;
    }

    public void setAssetsUnderManagement(PartnerEndCustomerAssetsUnderManagement assetsUnderManagement) {
        this.assetsUnderManagement = assetsUnderManagement;
    }

    public PartnerCustomerCreateRequest redirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public PartnerCustomerCreateRequest addRedirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<String>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of URIs indicating the destination(s) where a user can be forwarded after completing the Link flow; used to support OAuth authentication flows when launching Link in the browser or another app. URIs should not contain any query parameters. When used in Production, URIs must use https. To specify any subdomain, use `*` as a wildcard character, e.g. `https://_*.example.com/oauth.html`. To modify redirect URIs for an end customer after creating them, go to the end customer's [API page](https://dashboard.plaid.com/team/api) in the Dashboard.")
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public PartnerCustomerCreateRequest registrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier assigned to a financial institution by regulatory authorities, if applicable. For banks, this is the FDIC Certificate Number. For credit unions, this is the Credit Union Charter Number.")
    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartnerCustomerCreateRequest partnerCustomerCreateRequest = (PartnerCustomerCreateRequest)o;
        return Objects.equals(this.clientId, partnerCustomerCreateRequest.clientId) && Objects.equals(this.secret, partnerCustomerCreateRequest.secret) && Objects.equals(this.companyName, partnerCustomerCreateRequest.companyName) && Objects.equals(this.isDiligenceAttested, partnerCustomerCreateRequest.isDiligenceAttested) && Objects.equals(this.products, partnerCustomerCreateRequest.products) && Objects.equals(this.createLinkCustomization, partnerCustomerCreateRequest.createLinkCustomization) && Objects.equals(this.logo, partnerCustomerCreateRequest.logo) && Objects.equals(this.legalEntityName, partnerCustomerCreateRequest.legalEntityName) && Objects.equals(this.website, partnerCustomerCreateRequest.website) && Objects.equals(this.applicationName, partnerCustomerCreateRequest.applicationName) && Objects.equals(this.technicalContact, partnerCustomerCreateRequest.technicalContact) && Objects.equals(this.billingContact, partnerCustomerCreateRequest.billingContact) && Objects.equals(this.customerSupportInfo, partnerCustomerCreateRequest.customerSupportInfo) && Objects.equals(this.address, partnerCustomerCreateRequest.address) && Objects.equals(this.isBankAddendumCompleted, partnerCustomerCreateRequest.isBankAddendumCompleted) && Objects.equals(this.assetsUnderManagement, partnerCustomerCreateRequest.assetsUnderManagement) && Objects.equals(this.redirectUris, partnerCustomerCreateRequest.redirectUris) && Objects.equals(this.registrationNumber, partnerCustomerCreateRequest.registrationNumber);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.companyName, this.isDiligenceAttested, this.products, this.createLinkCustomization, this.logo, this.legalEntityName, this.website, this.applicationName, this.technicalContact, this.billingContact, this.customerSupportInfo, this.address, this.isBankAddendumCompleted, this.assetsUnderManagement, this.redirectUris, this.registrationNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartnerCustomerCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    isDiligenceAttested: ").append(this.toIndentedString(this.isDiligenceAttested)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("    createLinkCustomization: ").append(this.toIndentedString(this.createLinkCustomization)).append("\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    legalEntityName: ").append(this.toIndentedString(this.legalEntityName)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("    applicationName: ").append(this.toIndentedString(this.applicationName)).append("\n");
        sb.append("    technicalContact: ").append(this.toIndentedString(this.technicalContact)).append("\n");
        sb.append("    billingContact: ").append(this.toIndentedString(this.billingContact)).append("\n");
        sb.append("    customerSupportInfo: ").append(this.toIndentedString(this.customerSupportInfo)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    isBankAddendumCompleted: ").append(this.toIndentedString(this.isBankAddendumCompleted)).append("\n");
        sb.append("    assetsUnderManagement: ").append(this.toIndentedString(this.assetsUnderManagement)).append("\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("    registrationNumber: ").append(this.toIndentedString(this.registrationNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

