/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The secrets for the newly created end customer.")
public class PartnerEndCustomerSecrets {
    public static final String SERIALIZED_NAME_SANDBOX = "sandbox";
    @SerializedName(value="sandbox")
    private String sandbox;
    public static final String SERIALIZED_NAME_DEVELOPMENT = "development";
    @SerializedName(value="development")
    private String development;
    public static final String SERIALIZED_NAME_PRODUCTION = "production";
    @SerializedName(value="production")
    private String production;

    public PartnerEndCustomerSecrets sandbox(String sandbox) {
        this.sandbox = sandbox;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end customer's secret key for the Sandbox environment.")
    public String getSandbox() {
        return this.sandbox;
    }

    public void setSandbox(String sandbox) {
        this.sandbox = sandbox;
    }

    public PartnerEndCustomerSecrets development(String development) {
        this.development = development;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end customer's secret key for the Development environment. The Development environment has been removed.")
    public String getDevelopment() {
        return this.development;
    }

    public void setDevelopment(String development) {
        this.development = development;
    }

    public PartnerEndCustomerSecrets production(String production) {
        this.production = production;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end customer's secret key for the Production environment. The end customer will be provided with a limited number of credits to test in the Production environment before full enablement.")
    public String getProduction() {
        return this.production;
    }

    public void setProduction(String production) {
        this.production = production;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartnerEndCustomerSecrets partnerEndCustomerSecrets = (PartnerEndCustomerSecrets)o;
        return Objects.equals(this.sandbox, partnerEndCustomerSecrets.sandbox) && Objects.equals(this.development, partnerEndCustomerSecrets.development) && Objects.equals(this.production, partnerEndCustomerSecrets.production);
    }

    public int hashCode() {
        return Objects.hash(this.sandbox, this.development, this.production);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartnerEndCustomerSecrets {\n");
        sb.append("    sandbox: ").append(this.toIndentedString(this.sandbox)).append("\n");
        sb.append("    development: ").append(this.toIndentedString(this.development)).append("\n");
        sb.append("    production: ").append(this.toIndentedString(this.production)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

