/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information about the accounts that the payment was distributed to.")
public class PayStubDistributionBreakdown {
    public static final String SERIALIZED_NAME_ACCOUNT_NAME = "account_name";
    @SerializedName(value="account_name")
    private String accountName;
    public static final String SERIALIZED_NAME_BANK_NAME = "bank_name";
    @SerializedName(value="bank_name")
    private String bankName;
    public static final String SERIALIZED_NAME_CURRENT_AMOUNT = "current_amount";
    @SerializedName(value="current_amount")
    private Double currentAmount;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_MASK = "mask";
    @SerializedName(value="mask")
    private String mask;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;

    public PayStubDistributionBreakdown accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Name of the account for the given distribution.")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public PayStubDistributionBreakdown bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The name of the bank that the payment is being deposited to.")
    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public PayStubDistributionBreakdown currentAmount(Double currentAmount) {
        this.currentAmount = currentAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The amount distributed to this account.")
    public Double getCurrentAmount() {
        return this.currentAmount;
    }

    public void setCurrentAmount(Double currentAmount) {
        this.currentAmount = currentAmount;
    }

    public PayStubDistributionBreakdown isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ISO-4217 currency code of the net pay. Always `null` if `unofficial_currency_code` is non-null.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public PayStubDistributionBreakdown mask(String mask) {
        this.mask = mask;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The last 2-4 alphanumeric characters of an account's official account number.")
    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public PayStubDistributionBreakdown type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Type of the account that the paystub was sent to (e.g. 'checking').")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public PayStubDistributionBreakdown unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The unofficial currency code associated with the net pay. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayStubDistributionBreakdown payStubDistributionBreakdown = (PayStubDistributionBreakdown)o;
        return Objects.equals(this.accountName, payStubDistributionBreakdown.accountName) && Objects.equals(this.bankName, payStubDistributionBreakdown.bankName) && Objects.equals(this.currentAmount, payStubDistributionBreakdown.currentAmount) && Objects.equals(this.isoCurrencyCode, payStubDistributionBreakdown.isoCurrencyCode) && Objects.equals(this.mask, payStubDistributionBreakdown.mask) && Objects.equals(this.type, payStubDistributionBreakdown.type) && Objects.equals(this.unofficialCurrencyCode, payStubDistributionBreakdown.unofficialCurrencyCode);
    }

    public int hashCode() {
        return Objects.hash(this.accountName, this.bankName, this.currentAmount, this.isoCurrencyCode, this.mask, this.type, this.unofficialCurrencyCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayStubDistributionBreakdown {\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("    currentAmount: ").append(this.toIndentedString(this.currentAmount)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    mask: ").append(this.toIndentedString(this.mask)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

