/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing the earnings line items for the pay period.")
public class PayStubEarningsBreakdown {
    public static final String SERIALIZED_NAME_CANONICAL_DESCRIPTION = "canonical_description";
    @SerializedName(value="canonical_description")
    private String canonicalDescription;
    public static final String SERIALIZED_NAME_CURRENT_AMOUNT = "current_amount";
    @SerializedName(value="current_amount")
    private Double currentAmount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_HOURS = "hours";
    @SerializedName(value="hours")
    private Double hours;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_RATE = "rate";
    @SerializedName(value="rate")
    private Double rate;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;
    public static final String SERIALIZED_NAME_YTD_AMOUNT = "ytd_amount";
    @SerializedName(value="ytd_amount")
    private Double ytdAmount;

    public PayStubEarningsBreakdown canonicalDescription(String canonicalDescription) {
        this.canonicalDescription = canonicalDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Commonly used term to describe the earning line item.")
    public String getCanonicalDescription() {
        return this.canonicalDescription;
    }

    public void setCanonicalDescription(String canonicalDescription) {
        this.canonicalDescription = canonicalDescription;
    }

    public PayStubEarningsBreakdown currentAmount(Double currentAmount) {
        this.currentAmount = currentAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Raw amount of the earning line item.")
    public Double getCurrentAmount() {
        return this.currentAmount;
    }

    public void setCurrentAmount(Double currentAmount) {
        this.currentAmount = currentAmount;
    }

    public PayStubEarningsBreakdown description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Description of the earning line item.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PayStubEarningsBreakdown hours(Double hours) {
        this.hours = hours;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Number of hours applicable for this earning.")
    public Double getHours() {
        return this.hours;
    }

    public void setHours(Double hours) {
        this.hours = hours;
    }

    public PayStubEarningsBreakdown isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ISO-4217 currency code of the line item. Always `null` if `unofficial_currency_code` is non-null.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public PayStubEarningsBreakdown rate(Double rate) {
        this.rate = rate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Hourly rate applicable for this earning.")
    public Double getRate() {
        return this.rate;
    }

    public void setRate(Double rate) {
        this.rate = rate;
    }

    public PayStubEarningsBreakdown unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The unofficial currency code associated with the line item. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public PayStubEarningsBreakdown ytdAmount(Double ytdAmount) {
        this.ytdAmount = ytdAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The year-to-date amount of the deduction.")
    public Double getYtdAmount() {
        return this.ytdAmount;
    }

    public void setYtdAmount(Double ytdAmount) {
        this.ytdAmount = ytdAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayStubEarningsBreakdown payStubEarningsBreakdown = (PayStubEarningsBreakdown)o;
        return Objects.equals(this.canonicalDescription, payStubEarningsBreakdown.canonicalDescription) && Objects.equals(this.currentAmount, payStubEarningsBreakdown.currentAmount) && Objects.equals(this.description, payStubEarningsBreakdown.description) && Objects.equals(this.hours, payStubEarningsBreakdown.hours) && Objects.equals(this.isoCurrencyCode, payStubEarningsBreakdown.isoCurrencyCode) && Objects.equals(this.rate, payStubEarningsBreakdown.rate) && Objects.equals(this.unofficialCurrencyCode, payStubEarningsBreakdown.unofficialCurrencyCode) && Objects.equals(this.ytdAmount, payStubEarningsBreakdown.ytdAmount);
    }

    public int hashCode() {
        return Objects.hash(this.canonicalDescription, this.currentAmount, this.description, this.hours, this.isoCurrencyCode, this.rate, this.unofficialCurrencyCode, this.ytdAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayStubEarningsBreakdown {\n");
        sb.append("    canonicalDescription: ").append(this.toIndentedString(this.canonicalDescription)).append("\n");
        sb.append("    currentAmount: ").append(this.toIndentedString(this.currentAmount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    hours: ").append(this.toIndentedString(this.hours)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("    ytdAmount: ").append(this.toIndentedString(this.ytdAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

