/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing both the current pay period and year to date amount for an earning category.")
public class PayStubEarningsTotal {
    public static final String SERIALIZED_NAME_CURRENT_AMOUNT = "current_amount";
    @SerializedName(value="current_amount")
    private Double currentAmount;
    public static final String SERIALIZED_NAME_HOURS = "hours";
    @SerializedName(value="hours")
    private Double hours;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;
    public static final String SERIALIZED_NAME_YTD_AMOUNT = "ytd_amount";
    @SerializedName(value="ytd_amount")
    private Double ytdAmount;

    public PayStubEarningsTotal currentAmount(Double currentAmount) {
        this.currentAmount = currentAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Total amount of the earnings for this pay period.")
    public Double getCurrentAmount() {
        return this.currentAmount;
    }

    public void setCurrentAmount(Double currentAmount) {
        this.currentAmount = currentAmount;
    }

    public PayStubEarningsTotal hours(Double hours) {
        this.hours = hours;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Total number of hours worked for this pay period.")
    public Double getHours() {
        return this.hours;
    }

    public void setHours(Double hours) {
        this.hours = hours;
    }

    public PayStubEarningsTotal isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ISO-4217 currency code of the line item. Always `null` if `unofficial_currency_code` is non-null.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public PayStubEarningsTotal unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The unofficial currency code associated with the security. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public PayStubEarningsTotal ytdAmount(Double ytdAmount) {
        this.ytdAmount = ytdAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The total year-to-date amount of the earnings.")
    public Double getYtdAmount() {
        return this.ytdAmount;
    }

    public void setYtdAmount(Double ytdAmount) {
        this.ytdAmount = ytdAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayStubEarningsTotal payStubEarningsTotal = (PayStubEarningsTotal)o;
        return Objects.equals(this.currentAmount, payStubEarningsTotal.currentAmount) && Objects.equals(this.hours, payStubEarningsTotal.hours) && Objects.equals(this.isoCurrencyCode, payStubEarningsTotal.isoCurrencyCode) && Objects.equals(this.unofficialCurrencyCode, payStubEarningsTotal.unofficialCurrencyCode) && Objects.equals(this.ytdAmount, payStubEarningsTotal.ytdAmount);
    }

    public int hashCode() {
        return Objects.hash(this.currentAmount, this.hours, this.isoCurrencyCode, this.unofficialCurrencyCode, this.ytdAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayStubEarningsTotal {\n");
        sb.append("    currentAmount: ").append(this.toIndentedString(this.currentAmount)).append("\n");
        sb.append("    hours: ").append(this.toIndentedString(this.hours)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("    ytdAmount: ").append(this.toIndentedString(this.ytdAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

