/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditPayStubPayBasisType;
import com.plaid.client.model.PayStubDistributionBreakdown;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Details about the pay period.")
public class PayStubPayPeriodDetails {
    public static final String SERIALIZED_NAME_PAY_AMOUNT = "pay_amount";
    @SerializedName(value="pay_amount")
    private Double payAmount;
    public static final String SERIALIZED_NAME_DISTRIBUTION_BREAKDOWN = "distribution_breakdown";
    @SerializedName(value="distribution_breakdown")
    private List<PayStubDistributionBreakdown> distributionBreakdown = new ArrayList<PayStubDistributionBreakdown>();
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_GROSS_EARNINGS = "gross_earnings";
    @SerializedName(value="gross_earnings")
    private Double grossEarnings;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_PAY_DATE = "pay_date";
    @SerializedName(value="pay_date")
    private LocalDate payDate;
    public static final String SERIALIZED_NAME_PAY_FREQUENCY = "pay_frequency";
    @SerializedName(value="pay_frequency")
    private String payFrequency;
    public static final String SERIALIZED_NAME_PAY_BASIS = "pay_basis";
    @SerializedName(value="pay_basis")
    private CreditPayStubPayBasisType payBasis;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;

    public PayStubPayPeriodDetails payAmount(Double payAmount) {
        this.payAmount = payAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The amount of the paycheck.")
    public Double getPayAmount() {
        return this.payAmount;
    }

    public void setPayAmount(Double payAmount) {
        this.payAmount = payAmount;
    }

    public PayStubPayPeriodDetails distributionBreakdown(List<PayStubDistributionBreakdown> distributionBreakdown) {
        this.distributionBreakdown = distributionBreakdown;
        return this;
    }

    public PayStubPayPeriodDetails addDistributionBreakdownItem(PayStubDistributionBreakdown distributionBreakdownItem) {
        this.distributionBreakdown.add(distributionBreakdownItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<PayStubDistributionBreakdown> getDistributionBreakdown() {
        return this.distributionBreakdown;
    }

    public void setDistributionBreakdown(List<PayStubDistributionBreakdown> distributionBreakdown) {
        this.distributionBreakdown = distributionBreakdown;
    }

    public PayStubPayPeriodDetails endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date on which the pay period ended, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (\"yyyy-mm-dd\").")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public PayStubPayPeriodDetails grossEarnings(Double grossEarnings) {
        this.grossEarnings = grossEarnings;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Total earnings before tax/deductions.")
    public Double getGrossEarnings() {
        return this.grossEarnings;
    }

    public void setGrossEarnings(Double grossEarnings) {
        this.grossEarnings = grossEarnings;
    }

    public PayStubPayPeriodDetails isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ISO-4217 currency code of the net pay. Always `null` if `unofficial_currency_code` is non-null.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public PayStubPayPeriodDetails payDate(LocalDate payDate) {
        this.payDate = payDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date on which the pay stub was issued, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (\"yyyy-mm-dd\").")
    public LocalDate getPayDate() {
        return this.payDate;
    }

    public void setPayDate(LocalDate payDate) {
        this.payDate = payDate;
    }

    public PayStubPayPeriodDetails payFrequency(String payFrequency) {
        this.payFrequency = payFrequency;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The frequency at which an individual is paid.")
    public String getPayFrequency() {
        return this.payFrequency;
    }

    public void setPayFrequency(String payFrequency) {
        this.payFrequency = payFrequency;
    }

    public PayStubPayPeriodDetails payBasis(CreditPayStubPayBasisType payBasis) {
        this.payBasis = payBasis;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreditPayStubPayBasisType getPayBasis() {
        return this.payBasis;
    }

    public void setPayBasis(CreditPayStubPayBasisType payBasis) {
        this.payBasis = payBasis;
    }

    public PayStubPayPeriodDetails startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date on which the pay period started, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (\"yyyy-mm-dd\").")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public PayStubPayPeriodDetails unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The unofficial currency code associated with the net pay. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayStubPayPeriodDetails payStubPayPeriodDetails = (PayStubPayPeriodDetails)o;
        return Objects.equals(this.payAmount, payStubPayPeriodDetails.payAmount) && Objects.equals(this.distributionBreakdown, payStubPayPeriodDetails.distributionBreakdown) && Objects.equals(this.endDate, payStubPayPeriodDetails.endDate) && Objects.equals(this.grossEarnings, payStubPayPeriodDetails.grossEarnings) && Objects.equals(this.isoCurrencyCode, payStubPayPeriodDetails.isoCurrencyCode) && Objects.equals(this.payDate, payStubPayPeriodDetails.payDate) && Objects.equals(this.payFrequency, payStubPayPeriodDetails.payFrequency) && Objects.equals((Object)this.payBasis, (Object)payStubPayPeriodDetails.payBasis) && Objects.equals(this.startDate, payStubPayPeriodDetails.startDate) && Objects.equals(this.unofficialCurrencyCode, payStubPayPeriodDetails.unofficialCurrencyCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.payAmount, this.distributionBreakdown, this.endDate, this.grossEarnings, this.isoCurrencyCode, this.payDate, this.payFrequency, this.payBasis, this.startDate, this.unofficialCurrencyCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayStubPayPeriodDetails {\n");
        sb.append("    payAmount: ").append(this.toIndentedString(this.payAmount)).append("\n");
        sb.append("    distributionBreakdown: ").append(this.toIndentedString(this.distributionBreakdown)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    grossEarnings: ").append(this.toIndentedString(this.grossEarnings)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    payDate: ").append(this.toIndentedString(this.payDate)).append("\n");
        sb.append("    payFrequency: ").append(this.toIndentedString(this.payFrequency)).append("\n");
        sb.append("    payBasis: ").append(this.toIndentedString((Object)this.payBasis)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

