/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Life span for the payment consent. After the `to` date the payment consent expires and can no longer be used for payment initiation.")
public class PaymentConsentValidDateTime {
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private OffsetDateTime from;
    public static final String SERIALIZED_NAME_TO = "to";
    @SerializedName(value="to")
    private OffsetDateTime to;

    public PaymentConsentValidDateTime from(OffsetDateTime from) {
        this.from = from;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time from which the consent should be active, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.")
    public OffsetDateTime getFrom() {
        return this.from;
    }

    public void setFrom(OffsetDateTime from) {
        this.from = from;
    }

    public PaymentConsentValidDateTime to(OffsetDateTime to) {
        this.to = to;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time at which the consent expires, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.")
    public OffsetDateTime getTo() {
        return this.to;
    }

    public void setTo(OffsetDateTime to) {
        this.to = to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentConsentValidDateTime paymentConsentValidDateTime = (PaymentConsentValidDateTime)o;
        return Objects.equals(this.from, paymentConsentValidDateTime.from) && Objects.equals(this.to, paymentConsentValidDateTime.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentConsentValidDateTime {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

