/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The optional address of the payment recipient's bank account. Required by most institutions outside of the UK.")
public class PaymentInitiationAddress {
    public static final String SERIALIZED_NAME_STREET = "street";
    @SerializedName(value="street")
    private List<String> street = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
    @SerializedName(value="postal_code")
    private String postalCode;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;

    public PaymentInitiationAddress street(List<String> street) {
        this.street = street;
        return this;
    }

    public PaymentInitiationAddress addStreetItem(String streetItem) {
        this.street.add(streetItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of length 1-2 representing the street address where the recipient is located. Maximum of 70 characters.")
    public List<String> getStreet() {
        return this.street;
    }

    public void setStreet(List<String> street) {
        this.street = street;
    }

    public PaymentInitiationAddress city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(required=true, value="The city where the recipient is located. Maximum of 35 characters.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public PaymentInitiationAddress postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The postal code where the recipient is located. Maximum of 16 characters.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public PaymentInitiationAddress country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(required=true, value="The ISO 3166-1 alpha-2 country code where the recipient is located.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationAddress paymentInitiationAddress = (PaymentInitiationAddress)o;
        return Objects.equals(this.street, paymentInitiationAddress.street) && Objects.equals(this.city, paymentInitiationAddress.city) && Objects.equals(this.postalCode, paymentInitiationAddress.postalCode) && Objects.equals(this.country, paymentInitiationAddress.country);
    }

    public int hashCode() {
        return Objects.hash(this.street, this.city, this.postalCode, this.country);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationAddress {\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

