/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ExternalPaymentInitiationConsentOptions;
import com.plaid.client.model.PaymentInitiationConsentConstraints;
import com.plaid.client.model.PaymentInitiationConsentScope;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="PaymentInitiationConsentCreateRequest defines the request schema for `/payment_initiation/consent/create`")
public class PaymentInitiationConsentCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_RECIPIENT_ID = "recipient_id";
    @SerializedName(value="recipient_id")
    private String recipientId;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_SCOPES = "scopes";
    @SerializedName(value="scopes")
    private Set<PaymentInitiationConsentScope> scopes = new LinkedHashSet<PaymentInitiationConsentScope>();
    public static final String SERIALIZED_NAME_CONSTRAINTS = "constraints";
    @SerializedName(value="constraints")
    private PaymentInitiationConsentConstraints constraints;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private ExternalPaymentInitiationConsentOptions options;

    public PaymentInitiationConsentCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public PaymentInitiationConsentCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public PaymentInitiationConsentCreateRequest recipientId(String recipientId) {
        this.recipientId = recipientId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the recipient the payment consent is for. The created consent can be used to transfer funds to this recipient only.")
    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public PaymentInitiationConsentCreateRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="A reference for the payment consent. This must be an alphanumeric string with at most 18 characters and must not contain any special characters.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentInitiationConsentCreateRequest scopes(Set<PaymentInitiationConsentScope> scopes) {
        this.scopes = scopes;
        return this;
    }

    public PaymentInitiationConsentCreateRequest addScopesItem(PaymentInitiationConsentScope scopesItem) {
        this.scopes.add(scopesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of payment consent scopes.")
    public Set<PaymentInitiationConsentScope> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<PaymentInitiationConsentScope> scopes) {
        this.scopes = scopes;
    }

    public PaymentInitiationConsentCreateRequest constraints(PaymentInitiationConsentConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PaymentInitiationConsentConstraints getConstraints() {
        return this.constraints;
    }

    public void setConstraints(PaymentInitiationConsentConstraints constraints) {
        this.constraints = constraints;
    }

    public PaymentInitiationConsentCreateRequest options(ExternalPaymentInitiationConsentOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ExternalPaymentInitiationConsentOptions getOptions() {
        return this.options;
    }

    public void setOptions(ExternalPaymentInitiationConsentOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationConsentCreateRequest paymentInitiationConsentCreateRequest = (PaymentInitiationConsentCreateRequest)o;
        return Objects.equals(this.clientId, paymentInitiationConsentCreateRequest.clientId) && Objects.equals(this.secret, paymentInitiationConsentCreateRequest.secret) && Objects.equals(this.recipientId, paymentInitiationConsentCreateRequest.recipientId) && Objects.equals(this.reference, paymentInitiationConsentCreateRequest.reference) && Objects.equals(this.scopes, paymentInitiationConsentCreateRequest.scopes) && Objects.equals(this.constraints, paymentInitiationConsentCreateRequest.constraints) && Objects.equals(this.options, paymentInitiationConsentCreateRequest.options);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.recipientId, this.reference, this.scopes, this.constraints, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationConsentCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    recipientId: ").append(this.toIndentedString(this.recipientId)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    constraints: ").append(this.toIndentedString(this.constraints)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

