/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaymentInitiationConsentConstraints;
import com.plaid.client.model.PaymentInitiationConsentScope;
import com.plaid.client.model.PaymentInitiationConsentStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="PaymentInitiationConsentGetResponse defines the response schema for `/payment_initation/consent/get`")
public class PaymentInitiationConsentGetResponse {
    public static final String SERIALIZED_NAME_CONSENT_ID = "consent_id";
    @SerializedName(value="consent_id")
    private String consentId;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private PaymentInitiationConsentStatus status;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_RECIPIENT_ID = "recipient_id";
    @SerializedName(value="recipient_id")
    private String recipientId;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_CONSTRAINTS = "constraints";
    @SerializedName(value="constraints")
    private PaymentInitiationConsentConstraints constraints;
    public static final String SERIALIZED_NAME_SCOPES = "scopes";
    @SerializedName(value="scopes")
    private List<PaymentInitiationConsentScope> scopes = new ArrayList<PaymentInitiationConsentScope>();
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public PaymentInitiationConsentGetResponse consentId(String consentId) {
        this.consentId = consentId;
        return this;
    }

    @ApiModelProperty(required=true, value="The consent ID.")
    public String getConsentId() {
        return this.consentId;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public PaymentInitiationConsentGetResponse status(PaymentInitiationConsentStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PaymentInitiationConsentStatus getStatus() {
        return this.status;
    }

    public void setStatus(PaymentInitiationConsentStatus status) {
        this.status = status;
    }

    public PaymentInitiationConsentGetResponse createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="Consent creation timestamp, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public PaymentInitiationConsentGetResponse recipientId(String recipientId) {
        this.recipientId = recipientId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the recipient the payment consent is for.")
    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public PaymentInitiationConsentGetResponse reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="A reference for the payment consent.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentInitiationConsentGetResponse constraints(PaymentInitiationConsentConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PaymentInitiationConsentConstraints getConstraints() {
        return this.constraints;
    }

    public void setConstraints(PaymentInitiationConsentConstraints constraints) {
        this.constraints = constraints;
    }

    public PaymentInitiationConsentGetResponse scopes(List<PaymentInitiationConsentScope> scopes) {
        this.scopes = scopes;
        return this;
    }

    public PaymentInitiationConsentGetResponse addScopesItem(PaymentInitiationConsentScope scopesItem) {
        this.scopes.add(scopesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of payment consent scopes.")
    public List<PaymentInitiationConsentScope> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<PaymentInitiationConsentScope> scopes) {
        this.scopes = scopes;
    }

    public PaymentInitiationConsentGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationConsentGetResponse paymentInitiationConsentGetResponse = (PaymentInitiationConsentGetResponse)o;
        return Objects.equals(this.consentId, paymentInitiationConsentGetResponse.consentId) && Objects.equals((Object)this.status, (Object)paymentInitiationConsentGetResponse.status) && Objects.equals(this.createdAt, paymentInitiationConsentGetResponse.createdAt) && Objects.equals(this.recipientId, paymentInitiationConsentGetResponse.recipientId) && Objects.equals(this.reference, paymentInitiationConsentGetResponse.reference) && Objects.equals(this.constraints, paymentInitiationConsentGetResponse.constraints) && Objects.equals(this.scopes, paymentInitiationConsentGetResponse.scopes) && Objects.equals(this.requestId, paymentInitiationConsentGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.consentId, this.status, this.createdAt, this.recipientId, this.reference, this.constraints, this.scopes, this.requestId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationConsentGetResponse {\n");
        sb.append("    consentId: ").append(this.toIndentedString(this.consentId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    recipientId: ").append(this.toIndentedString(this.recipientId)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    constraints: ").append(this.toIndentedString(this.constraints)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

