/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaymentAmount;
import com.plaid.client.model.PaymentInitiationConsentScope;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PaymentInitiationConsentPaymentExecuteRequest defines the request schema for `/payment_initiation/consent/payment/execute`")
public class PaymentInitiationConsentPaymentExecuteRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_CONSENT_ID = "consent_id";
    @SerializedName(value="consent_id")
    private String consentId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private PaymentAmount amount;
    public static final String SERIALIZED_NAME_IDEMPOTENCY_KEY = "idempotency_key";
    @SerializedName(value="idempotency_key")
    private String idempotencyKey;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    private PaymentInitiationConsentScope scope;

    public PaymentInitiationConsentPaymentExecuteRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public PaymentInitiationConsentPaymentExecuteRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public PaymentInitiationConsentPaymentExecuteRequest consentId(String consentId) {
        this.consentId = consentId;
        return this;
    }

    @ApiModelProperty(required=true, value="The consent ID.")
    public String getConsentId() {
        return this.consentId;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public PaymentInitiationConsentPaymentExecuteRequest amount(PaymentAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PaymentAmount getAmount() {
        return this.amount;
    }

    public void setAmount(PaymentAmount amount) {
        this.amount = amount;
    }

    public PaymentInitiationConsentPaymentExecuteRequest idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @ApiModelProperty(required=true, value="A random key provided by the client, per unique consent payment. Maximum of 128 characters.  The API supports idempotency for safely retrying requests without accidentally performing the same operation twice. If a request to execute a consent payment fails due to a network connection error, you can retry the request with the same idempotency key to guarantee that only a single payment is created. If the request was successfully processed, it will prevent any payment that uses the same idempotency key, and was received within 48 hours of the first request, from being processed.")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public PaymentInitiationConsentPaymentExecuteRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A reference for the payment. This must be an alphanumeric string with at most 18 characters and must not contain any special characters (since not all institutions support them). If not provided, Plaid will automatically fall back to the reference from consent. In order to track settlement via Payment Confirmation, each payment must have a unique reference. If the reference provided through the API is not unique, Plaid will adjust it. Some institutions may limit the reference to less than 18 characters. If necessary, Plaid will adjust the reference by truncating it to fit the institution's requirements. Both the originally provided and automatically adjusted references (if any) can be found in the `reference` and `adjusted_reference` fields, respectively.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentInitiationConsentPaymentExecuteRequest scope(PaymentInitiationConsentScope scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentInitiationConsentScope getScope() {
        return this.scope;
    }

    public void setScope(PaymentInitiationConsentScope scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationConsentPaymentExecuteRequest paymentInitiationConsentPaymentExecuteRequest = (PaymentInitiationConsentPaymentExecuteRequest)o;
        return Objects.equals(this.clientId, paymentInitiationConsentPaymentExecuteRequest.clientId) && Objects.equals(this.secret, paymentInitiationConsentPaymentExecuteRequest.secret) && Objects.equals(this.consentId, paymentInitiationConsentPaymentExecuteRequest.consentId) && Objects.equals(this.amount, paymentInitiationConsentPaymentExecuteRequest.amount) && Objects.equals(this.idempotencyKey, paymentInitiationConsentPaymentExecuteRequest.idempotencyKey) && Objects.equals(this.reference, paymentInitiationConsentPaymentExecuteRequest.reference) && Objects.equals((Object)this.scope, (Object)paymentInitiationConsentPaymentExecuteRequest.scope);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.consentId, this.amount, this.idempotencyKey, this.reference, this.scope});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationConsentPaymentExecuteRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    consentId: ").append(this.toIndentedString(this.consentId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString((Object)this.scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

