/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaymentInitiationStandingOrderMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Metadata that captures what specific payment configurations an institution supports when making Payment Initiation requests.")
public class PaymentInitiationMetadata {
    public static final String SERIALIZED_NAME_SUPPORTS_INTERNATIONAL_PAYMENTS = "supports_international_payments";
    @SerializedName(value="supports_international_payments")
    private Boolean supportsInternationalPayments;
    public static final String SERIALIZED_NAME_SUPPORTS_SEPA_INSTANT = "supports_sepa_instant";
    @SerializedName(value="supports_sepa_instant")
    private Boolean supportsSepaInstant;
    public static final String SERIALIZED_NAME_MAXIMUM_PAYMENT_AMOUNT = "maximum_payment_amount";
    @SerializedName(value="maximum_payment_amount")
    private Map<String, String> maximumPaymentAmount = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_SUPPORTS_REFUND_DETAILS = "supports_refund_details";
    @SerializedName(value="supports_refund_details")
    private Boolean supportsRefundDetails;
    public static final String SERIALIZED_NAME_STANDING_ORDER_METADATA = "standing_order_metadata";
    @SerializedName(value="standing_order_metadata")
    private PaymentInitiationStandingOrderMetadata standingOrderMetadata;
    public static final String SERIALIZED_NAME_SUPPORTS_PAYMENT_CONSENTS = "supports_payment_consents";
    @SerializedName(value="supports_payment_consents")
    private Boolean supportsPaymentConsents;

    public PaymentInitiationMetadata supportsInternationalPayments(Boolean supportsInternationalPayments) {
        this.supportsInternationalPayments = supportsInternationalPayments;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the institution supports payments from a different country.")
    public Boolean getSupportsInternationalPayments() {
        return this.supportsInternationalPayments;
    }

    public void setSupportsInternationalPayments(Boolean supportsInternationalPayments) {
        this.supportsInternationalPayments = supportsInternationalPayments;
    }

    public PaymentInitiationMetadata supportsSepaInstant(Boolean supportsSepaInstant) {
        this.supportsSepaInstant = supportsSepaInstant;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the institution supports SEPA Instant payments.")
    public Boolean getSupportsSepaInstant() {
        return this.supportsSepaInstant;
    }

    public void setSupportsSepaInstant(Boolean supportsSepaInstant) {
        this.supportsSepaInstant = supportsSepaInstant;
    }

    public PaymentInitiationMetadata maximumPaymentAmount(Map<String, String> maximumPaymentAmount) {
        this.maximumPaymentAmount = maximumPaymentAmount;
        return this;
    }

    public PaymentInitiationMetadata putMaximumPaymentAmountItem(String key, String maximumPaymentAmountItem) {
        this.maximumPaymentAmount.put(key, maximumPaymentAmountItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A mapping of currency to maximum payment amount (denominated in the smallest unit of currency) supported by the institution.  Example: `{\"GBP\": \"10000\"}` ")
    public Map<String, String> getMaximumPaymentAmount() {
        return this.maximumPaymentAmount;
    }

    public void setMaximumPaymentAmount(Map<String, String> maximumPaymentAmount) {
        this.maximumPaymentAmount = maximumPaymentAmount;
    }

    public PaymentInitiationMetadata supportsRefundDetails(Boolean supportsRefundDetails) {
        this.supportsRefundDetails = supportsRefundDetails;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the institution supports returning refund details when initiating a payment.")
    public Boolean getSupportsRefundDetails() {
        return this.supportsRefundDetails;
    }

    public void setSupportsRefundDetails(Boolean supportsRefundDetails) {
        this.supportsRefundDetails = supportsRefundDetails;
    }

    public PaymentInitiationMetadata standingOrderMetadata(PaymentInitiationStandingOrderMetadata standingOrderMetadata) {
        this.standingOrderMetadata = standingOrderMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public PaymentInitiationStandingOrderMetadata getStandingOrderMetadata() {
        return this.standingOrderMetadata;
    }

    public void setStandingOrderMetadata(PaymentInitiationStandingOrderMetadata standingOrderMetadata) {
        this.standingOrderMetadata = standingOrderMetadata;
    }

    public PaymentInitiationMetadata supportsPaymentConsents(Boolean supportsPaymentConsents) {
        this.supportsPaymentConsents = supportsPaymentConsents;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the institution supports payment consents.")
    public Boolean getSupportsPaymentConsents() {
        return this.supportsPaymentConsents;
    }

    public void setSupportsPaymentConsents(Boolean supportsPaymentConsents) {
        this.supportsPaymentConsents = supportsPaymentConsents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationMetadata paymentInitiationMetadata = (PaymentInitiationMetadata)o;
        return Objects.equals(this.supportsInternationalPayments, paymentInitiationMetadata.supportsInternationalPayments) && Objects.equals(this.supportsSepaInstant, paymentInitiationMetadata.supportsSepaInstant) && Objects.equals(this.maximumPaymentAmount, paymentInitiationMetadata.maximumPaymentAmount) && Objects.equals(this.supportsRefundDetails, paymentInitiationMetadata.supportsRefundDetails) && Objects.equals(this.standingOrderMetadata, paymentInitiationMetadata.standingOrderMetadata) && Objects.equals(this.supportsPaymentConsents, paymentInitiationMetadata.supportsPaymentConsents);
    }

    public int hashCode() {
        return Objects.hash(this.supportsInternationalPayments, this.supportsSepaInstant, this.maximumPaymentAmount, this.supportsRefundDetails, this.standingOrderMetadata, this.supportsPaymentConsents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationMetadata {\n");
        sb.append("    supportsInternationalPayments: ").append(this.toIndentedString(this.supportsInternationalPayments)).append("\n");
        sb.append("    supportsSepaInstant: ").append(this.toIndentedString(this.supportsSepaInstant)).append("\n");
        sb.append("    maximumPaymentAmount: ").append(this.toIndentedString(this.maximumPaymentAmount)).append("\n");
        sb.append("    supportsRefundDetails: ").append(this.toIndentedString(this.supportsRefundDetails)).append("\n");
        sb.append("    standingOrderMetadata: ").append(this.toIndentedString(this.standingOrderMetadata)).append("\n");
        sb.append("    supportsPaymentConsents: ").append(this.toIndentedString(this.supportsPaymentConsents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

