/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ExternalPaymentOptions;
import com.plaid.client.model.ExternalPaymentScheduleRequest;
import com.plaid.client.model.PaymentAmount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PaymentInitiationPaymentCreateRequest defines the request schema for `/payment_initiation/payment/create`")
public class PaymentInitiationPaymentCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_RECIPIENT_ID = "recipient_id";
    @SerializedName(value="recipient_id")
    private String recipientId;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private PaymentAmount amount;
    public static final String SERIALIZED_NAME_SCHEDULE = "schedule";
    @SerializedName(value="schedule")
    private ExternalPaymentScheduleRequest schedule;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private ExternalPaymentOptions options;

    public PaymentInitiationPaymentCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public PaymentInitiationPaymentCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public PaymentInitiationPaymentCreateRequest recipientId(String recipientId) {
        this.recipientId = recipientId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the recipient the payment is for.")
    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public PaymentInitiationPaymentCreateRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="A reference for the payment. This must be an alphanumeric string with at most 18 characters and must not contain any special characters (since not all institutions support them). In order to track settlement via Payment Confirmation, each payment must have a unique reference. If the reference provided through the API is not unique, Plaid will adjust it. Some institutions may limit the reference to less than 18 characters. If necessary, Plaid will adjust the reference by truncating it to fit the institution's requirements. Both the originally provided and automatically adjusted references (if any) can be found in the `reference` and `adjusted_reference` fields, respectively.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentInitiationPaymentCreateRequest amount(PaymentAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PaymentAmount getAmount() {
        return this.amount;
    }

    public void setAmount(PaymentAmount amount) {
        this.amount = amount;
    }

    public PaymentInitiationPaymentCreateRequest schedule(ExternalPaymentScheduleRequest schedule) {
        this.schedule = schedule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ExternalPaymentScheduleRequest getSchedule() {
        return this.schedule;
    }

    public void setSchedule(ExternalPaymentScheduleRequest schedule) {
        this.schedule = schedule;
    }

    public PaymentInitiationPaymentCreateRequest options(ExternalPaymentOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ExternalPaymentOptions getOptions() {
        return this.options;
    }

    public void setOptions(ExternalPaymentOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationPaymentCreateRequest paymentInitiationPaymentCreateRequest = (PaymentInitiationPaymentCreateRequest)o;
        return Objects.equals(this.clientId, paymentInitiationPaymentCreateRequest.clientId) && Objects.equals(this.secret, paymentInitiationPaymentCreateRequest.secret) && Objects.equals(this.recipientId, paymentInitiationPaymentCreateRequest.recipientId) && Objects.equals(this.reference, paymentInitiationPaymentCreateRequest.reference) && Objects.equals(this.amount, paymentInitiationPaymentCreateRequest.amount) && Objects.equals(this.schedule, paymentInitiationPaymentCreateRequest.schedule) && Objects.equals(this.options, paymentInitiationPaymentCreateRequest.options);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.recipientId, this.reference, this.amount, this.schedule, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationPaymentCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    recipientId: ").append(this.toIndentedString(this.recipientId)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

