/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ExternalPaymentRefundDetails;
import com.plaid.client.model.ExternalPaymentScheduleGet;
import com.plaid.client.model.PaymentAmount;
import com.plaid.client.model.PaymentAmountRefunded;
import com.plaid.client.model.PaymentInitiationPaymentStatus;
import com.plaid.client.model.PaymentScheme;
import com.plaid.client.model.SenderBACSNullable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PaymentInitiationPaymentGetResponse defines the response schema for `/payment_initation/payment/get`")
public class PaymentInitiationPaymentGetResponse {
    public static final String SERIALIZED_NAME_PAYMENT_ID = "payment_id";
    @SerializedName(value="payment_id")
    private String paymentId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private PaymentAmount amount;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private PaymentInitiationPaymentStatus status;
    public static final String SERIALIZED_NAME_RECIPIENT_ID = "recipient_id";
    @SerializedName(value="recipient_id")
    private String recipientId;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_ADJUSTED_REFERENCE = "adjusted_reference";
    @SerializedName(value="adjusted_reference")
    private String adjustedReference;
    public static final String SERIALIZED_NAME_LAST_STATUS_UPDATE = "last_status_update";
    @SerializedName(value="last_status_update")
    private OffsetDateTime lastStatusUpdate;
    public static final String SERIALIZED_NAME_SCHEDULE = "schedule";
    @SerializedName(value="schedule")
    private ExternalPaymentScheduleGet schedule;
    public static final String SERIALIZED_NAME_REFUND_DETAILS = "refund_details";
    @SerializedName(value="refund_details")
    private ExternalPaymentRefundDetails refundDetails;
    public static final String SERIALIZED_NAME_BACS = "bacs";
    @SerializedName(value="bacs")
    private SenderBACSNullable bacs;
    public static final String SERIALIZED_NAME_IBAN = "iban";
    @SerializedName(value="iban")
    private String iban;
    public static final String SERIALIZED_NAME_REFUND_IDS = "refund_ids";
    @SerializedName(value="refund_ids")
    private List<String> refundIds = null;
    public static final String SERIALIZED_NAME_AMOUNT_REFUNDED = "amount_refunded";
    @SerializedName(value="amount_refunded")
    private PaymentAmountRefunded amountRefunded;
    public static final String SERIALIZED_NAME_WALLET_ID = "wallet_id";
    @SerializedName(value="wallet_id")
    private String walletId;
    public static final String SERIALIZED_NAME_SCHEME = "scheme";
    @SerializedName(value="scheme")
    private PaymentScheme scheme;
    public static final String SERIALIZED_NAME_ADJUSTED_SCHEME = "adjusted_scheme";
    @SerializedName(value="adjusted_scheme")
    private PaymentScheme adjustedScheme;
    public static final String SERIALIZED_NAME_CONSENT_ID = "consent_id";
    @SerializedName(value="consent_id")
    private String consentId;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transaction_id";
    @SerializedName(value="transaction_id")
    private String transactionId;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public PaymentInitiationPaymentGetResponse paymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the payment. Like all Plaid identifiers, the `payment_id` is case sensitive.")
    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public PaymentInitiationPaymentGetResponse amount(PaymentAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PaymentAmount getAmount() {
        return this.amount;
    }

    public void setAmount(PaymentAmount amount) {
        this.amount = amount;
    }

    public PaymentInitiationPaymentGetResponse status(PaymentInitiationPaymentStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PaymentInitiationPaymentStatus getStatus() {
        return this.status;
    }

    public void setStatus(PaymentInitiationPaymentStatus status) {
        this.status = status;
    }

    public PaymentInitiationPaymentGetResponse recipientId(String recipientId) {
        this.recipientId = recipientId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the recipient")
    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public PaymentInitiationPaymentGetResponse reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="A reference for the payment.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentInitiationPaymentGetResponse adjustedReference(String adjustedReference) {
        this.adjustedReference = adjustedReference;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The value of the reference sent to the bank after adjustment to pass bank validation rules.")
    public String getAdjustedReference() {
        return this.adjustedReference;
    }

    public void setAdjustedReference(String adjustedReference) {
        this.adjustedReference = adjustedReference;
    }

    public PaymentInitiationPaymentGetResponse lastStatusUpdate(OffsetDateTime lastStatusUpdate) {
        this.lastStatusUpdate = lastStatusUpdate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time of the last time the `status` was updated, in IS0 8601 format")
    public OffsetDateTime getLastStatusUpdate() {
        return this.lastStatusUpdate;
    }

    public void setLastStatusUpdate(OffsetDateTime lastStatusUpdate) {
        this.lastStatusUpdate = lastStatusUpdate;
    }

    public PaymentInitiationPaymentGetResponse schedule(ExternalPaymentScheduleGet schedule) {
        this.schedule = schedule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ExternalPaymentScheduleGet getSchedule() {
        return this.schedule;
    }

    public void setSchedule(ExternalPaymentScheduleGet schedule) {
        this.schedule = schedule;
    }

    public PaymentInitiationPaymentGetResponse refundDetails(ExternalPaymentRefundDetails refundDetails) {
        this.refundDetails = refundDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ExternalPaymentRefundDetails getRefundDetails() {
        return this.refundDetails;
    }

    public void setRefundDetails(ExternalPaymentRefundDetails refundDetails) {
        this.refundDetails = refundDetails;
    }

    public PaymentInitiationPaymentGetResponse bacs(SenderBACSNullable bacs) {
        this.bacs = bacs;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public SenderBACSNullable getBacs() {
        return this.bacs;
    }

    public void setBacs(SenderBACSNullable bacs) {
        this.bacs = bacs;
    }

    public PaymentInitiationPaymentGetResponse iban(String iban) {
        this.iban = iban;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The International Bank Account Number (IBAN) for the sender, if specified in the `/payment_initiation/payment/create` call.")
    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public PaymentInitiationPaymentGetResponse refundIds(List<String> refundIds) {
        this.refundIds = refundIds;
        return this;
    }

    public PaymentInitiationPaymentGetResponse addRefundIdsItem(String refundIdsItem) {
        if (this.refundIds == null) {
            this.refundIds = new ArrayList<String>();
        }
        this.refundIds.add(refundIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Refund IDs associated with the payment.")
    public List<String> getRefundIds() {
        return this.refundIds;
    }

    public void setRefundIds(List<String> refundIds) {
        this.refundIds = refundIds;
    }

    public PaymentInitiationPaymentGetResponse amountRefunded(PaymentAmountRefunded amountRefunded) {
        this.amountRefunded = amountRefunded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentAmountRefunded getAmountRefunded() {
        return this.amountRefunded;
    }

    public void setAmountRefunded(PaymentAmountRefunded amountRefunded) {
        this.amountRefunded = amountRefunded;
    }

    public PaymentInitiationPaymentGetResponse walletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The EMI (E-Money Institution) wallet that this payment is associated with, if any. This wallet is used as an intermediary account to enable Plaid to reconcile the settlement of funds for Payment Initiation requests.")
    public String getWalletId() {
        return this.walletId;
    }

    public void setWalletId(String walletId) {
        this.walletId = walletId;
    }

    public PaymentInitiationPaymentGetResponse scheme(PaymentScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentScheme getScheme() {
        return this.scheme;
    }

    public void setScheme(PaymentScheme scheme) {
        this.scheme = scheme;
    }

    public PaymentInitiationPaymentGetResponse adjustedScheme(PaymentScheme adjustedScheme) {
        this.adjustedScheme = adjustedScheme;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentScheme getAdjustedScheme() {
        return this.adjustedScheme;
    }

    public void setAdjustedScheme(PaymentScheme adjustedScheme) {
        this.adjustedScheme = adjustedScheme;
    }

    public PaymentInitiationPaymentGetResponse consentId(String consentId) {
        this.consentId = consentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payment consent ID that this payment was initiated with. Is present only when payment was initiated using the payment consent.")
    public String getConsentId() {
        return this.consentId;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public PaymentInitiationPaymentGetResponse transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The transaction ID that this payment is associated with, if any. This is present only when a payment was initiated using virtual accounts.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public PaymentInitiationPaymentGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationPaymentGetResponse paymentInitiationPaymentGetResponse = (PaymentInitiationPaymentGetResponse)o;
        return Objects.equals(this.paymentId, paymentInitiationPaymentGetResponse.paymentId) && Objects.equals(this.amount, paymentInitiationPaymentGetResponse.amount) && Objects.equals((Object)this.status, (Object)paymentInitiationPaymentGetResponse.status) && Objects.equals(this.recipientId, paymentInitiationPaymentGetResponse.recipientId) && Objects.equals(this.reference, paymentInitiationPaymentGetResponse.reference) && Objects.equals(this.adjustedReference, paymentInitiationPaymentGetResponse.adjustedReference) && Objects.equals(this.lastStatusUpdate, paymentInitiationPaymentGetResponse.lastStatusUpdate) && Objects.equals(this.schedule, paymentInitiationPaymentGetResponse.schedule) && Objects.equals(this.refundDetails, paymentInitiationPaymentGetResponse.refundDetails) && Objects.equals(this.bacs, paymentInitiationPaymentGetResponse.bacs) && Objects.equals(this.iban, paymentInitiationPaymentGetResponse.iban) && Objects.equals(this.refundIds, paymentInitiationPaymentGetResponse.refundIds) && Objects.equals(this.amountRefunded, paymentInitiationPaymentGetResponse.amountRefunded) && Objects.equals(this.walletId, paymentInitiationPaymentGetResponse.walletId) && Objects.equals((Object)this.scheme, (Object)paymentInitiationPaymentGetResponse.scheme) && Objects.equals((Object)this.adjustedScheme, (Object)paymentInitiationPaymentGetResponse.adjustedScheme) && Objects.equals(this.consentId, paymentInitiationPaymentGetResponse.consentId) && Objects.equals(this.transactionId, paymentInitiationPaymentGetResponse.transactionId) && Objects.equals(this.requestId, paymentInitiationPaymentGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paymentId, this.amount, this.status, this.recipientId, this.reference, this.adjustedReference, this.lastStatusUpdate, this.schedule, this.refundDetails, this.bacs, this.iban, this.refundIds, this.amountRefunded, this.walletId, this.scheme, this.adjustedScheme, this.consentId, this.transactionId, this.requestId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationPaymentGetResponse {\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    recipientId: ").append(this.toIndentedString(this.recipientId)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    adjustedReference: ").append(this.toIndentedString(this.adjustedReference)).append("\n");
        sb.append("    lastStatusUpdate: ").append(this.toIndentedString(this.lastStatusUpdate)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    refundDetails: ").append(this.toIndentedString(this.refundDetails)).append("\n");
        sb.append("    bacs: ").append(this.toIndentedString(this.bacs)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    refundIds: ").append(this.toIndentedString(this.refundIds)).append("\n");
        sb.append("    amountRefunded: ").append(this.toIndentedString(this.amountRefunded)).append("\n");
        sb.append("    walletId: ").append(this.toIndentedString(this.walletId)).append("\n");
        sb.append("    scheme: ").append(this.toIndentedString((Object)this.scheme)).append("\n");
        sb.append("    adjustedScheme: ").append(this.toIndentedString((Object)this.adjustedScheme)).append("\n");
        sb.append("    consentId: ").append(this.toIndentedString(this.consentId)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

