/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PaymentInitiationPaymentListRequest defines the request schema for `/payment_initiation/payment/list`")
public class PaymentInitiationPaymentListRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count = 10;
    public static final String SERIALIZED_NAME_CURSOR = "cursor";
    @SerializedName(value="cursor")
    private OffsetDateTime cursor;
    public static final String SERIALIZED_NAME_CONSENT_ID = "consent_id";
    @SerializedName(value="consent_id")
    private String consentId;

    public PaymentInitiationPaymentListRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public PaymentInitiationPaymentListRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public PaymentInitiationPaymentListRequest count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum number of payments to return. If `count` is not specified, a maximum of 10 payments will be returned, beginning with the most recent payment before the cursor (if specified).")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public PaymentInitiationPaymentListRequest cursor(OffsetDateTime cursor) {
        this.cursor = cursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A string in RFC 3339 format (i.e. \"2019-12-06T22:35:49Z\"). Only payments created before the cursor will be returned.")
    public OffsetDateTime getCursor() {
        return this.cursor;
    }

    public void setCursor(OffsetDateTime cursor) {
        this.cursor = cursor;
    }

    public PaymentInitiationPaymentListRequest consentId(String consentId) {
        this.consentId = consentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The consent ID. If specified, only payments, executed using this consent, will be returned.")
    public String getConsentId() {
        return this.consentId;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationPaymentListRequest paymentInitiationPaymentListRequest = (PaymentInitiationPaymentListRequest)o;
        return Objects.equals(this.clientId, paymentInitiationPaymentListRequest.clientId) && Objects.equals(this.secret, paymentInitiationPaymentListRequest.secret) && Objects.equals(this.count, paymentInitiationPaymentListRequest.count) && Objects.equals(this.cursor, paymentInitiationPaymentListRequest.cursor) && Objects.equals(this.consentId, paymentInitiationPaymentListRequest.consentId);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.count, this.cursor, this.consentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationPaymentListRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("    consentId: ").append(this.toIndentedString(this.consentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

