/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaymentInitiationPayment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PaymentInitiationPaymentListResponse defines the response schema for `/payment_initiation/payment/list`")
public class PaymentInitiationPaymentListResponse {
    public static final String SERIALIZED_NAME_PAYMENTS = "payments";
    @SerializedName(value="payments")
    private List<PaymentInitiationPayment> payments = new ArrayList<PaymentInitiationPayment>();
    public static final String SERIALIZED_NAME_NEXT_CURSOR = "next_cursor";
    @SerializedName(value="next_cursor")
    private OffsetDateTime nextCursor;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public PaymentInitiationPaymentListResponse payments(List<PaymentInitiationPayment> payments) {
        this.payments = payments;
        return this;
    }

    public PaymentInitiationPaymentListResponse addPaymentsItem(PaymentInitiationPayment paymentsItem) {
        this.payments.add(paymentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of payments that have been created, associated with the given `client_id`.")
    public List<PaymentInitiationPayment> getPayments() {
        return this.payments;
    }

    public void setPayments(List<PaymentInitiationPayment> payments) {
        this.payments = payments;
    }

    public PaymentInitiationPaymentListResponse nextCursor(OffsetDateTime nextCursor) {
        this.nextCursor = nextCursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The value that, when used as the optional `cursor` parameter to `/payment_initiation/payment/list`, will return the next unreturned payment as its first payment.")
    public OffsetDateTime getNextCursor() {
        return this.nextCursor;
    }

    public void setNextCursor(OffsetDateTime nextCursor) {
        this.nextCursor = nextCursor;
    }

    public PaymentInitiationPaymentListResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationPaymentListResponse paymentInitiationPaymentListResponse = (PaymentInitiationPaymentListResponse)o;
        return Objects.equals(this.payments, paymentInitiationPaymentListResponse.payments) && Objects.equals(this.nextCursor, paymentInitiationPaymentListResponse.nextCursor) && Objects.equals(this.requestId, paymentInitiationPaymentListResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.payments, this.nextCursor, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationPaymentListResponse {\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    nextCursor: ").append(this.toIndentedString(this.nextCursor)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

