/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaymentAmountToRefund;
import com.plaid.client.model.PaymentInitiationAddress;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PaymentInitiationPaymentReverseRequest defines the request schema for `/payment_initiation/payment/reverse`")
public class PaymentInitiationPaymentReverseRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_PAYMENT_ID = "payment_id";
    @SerializedName(value="payment_id")
    private String paymentId;
    public static final String SERIALIZED_NAME_IDEMPOTENCY_KEY = "idempotency_key";
    @SerializedName(value="idempotency_key")
    private String idempotencyKey;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private PaymentAmountToRefund amount;
    public static final String SERIALIZED_NAME_COUNTERPARTY_DATE_OF_BIRTH = "counterparty_date_of_birth";
    @SerializedName(value="counterparty_date_of_birth")
    private LocalDate counterpartyDateOfBirth;
    public static final String SERIALIZED_NAME_COUNTERPARTY_ADDRESS = "counterparty_address";
    @SerializedName(value="counterparty_address")
    private PaymentInitiationAddress counterpartyAddress;

    public PaymentInitiationPaymentReverseRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public PaymentInitiationPaymentReverseRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public PaymentInitiationPaymentReverseRequest paymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the payment to reverse")
    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public PaymentInitiationPaymentReverseRequest idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @ApiModelProperty(required=true, value="A random key provided by the client, per unique wallet transaction. Maximum of 128 characters.  The API supports idempotency for safely retrying requests without accidentally performing the same operation twice. If a request to execute a wallet transaction fails due to a network connection error, then after a minimum delay of one minute, you can retry the request with the same idempotency key to guarantee that only a single wallet transaction is created. If the request was successfully processed, it will prevent any transaction that uses the same idempotency key, and was received within 24 hours of the first request, from being processed.")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public PaymentInitiationPaymentReverseRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="A reference for the refund. This must be an alphanumeric string with 6 to 18 characters and must not contain any special characters or spaces.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentInitiationPaymentReverseRequest amount(PaymentAmountToRefund amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentAmountToRefund getAmount() {
        return this.amount;
    }

    public void setAmount(PaymentAmountToRefund amount) {
        this.amount = amount;
    }

    public PaymentInitiationPaymentReverseRequest counterpartyDateOfBirth(LocalDate counterpartyDateOfBirth) {
        this.counterpartyDateOfBirth = counterpartyDateOfBirth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The counterparty's birthdate, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format.")
    public LocalDate getCounterpartyDateOfBirth() {
        return this.counterpartyDateOfBirth;
    }

    public void setCounterpartyDateOfBirth(LocalDate counterpartyDateOfBirth) {
        this.counterpartyDateOfBirth = counterpartyDateOfBirth;
    }

    public PaymentInitiationPaymentReverseRequest counterpartyAddress(PaymentInitiationAddress counterpartyAddress) {
        this.counterpartyAddress = counterpartyAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentInitiationAddress getCounterpartyAddress() {
        return this.counterpartyAddress;
    }

    public void setCounterpartyAddress(PaymentInitiationAddress counterpartyAddress) {
        this.counterpartyAddress = counterpartyAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationPaymentReverseRequest paymentInitiationPaymentReverseRequest = (PaymentInitiationPaymentReverseRequest)o;
        return Objects.equals(this.clientId, paymentInitiationPaymentReverseRequest.clientId) && Objects.equals(this.secret, paymentInitiationPaymentReverseRequest.secret) && Objects.equals(this.paymentId, paymentInitiationPaymentReverseRequest.paymentId) && Objects.equals(this.idempotencyKey, paymentInitiationPaymentReverseRequest.idempotencyKey) && Objects.equals(this.reference, paymentInitiationPaymentReverseRequest.reference) && Objects.equals(this.amount, paymentInitiationPaymentReverseRequest.amount) && Objects.equals(this.counterpartyDateOfBirth, paymentInitiationPaymentReverseRequest.counterpartyDateOfBirth) && Objects.equals(this.counterpartyAddress, paymentInitiationPaymentReverseRequest.counterpartyAddress);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.paymentId, this.idempotencyKey, this.reference, this.amount, this.counterpartyDateOfBirth, this.counterpartyAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationPaymentReverseRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    counterpartyDateOfBirth: ").append(this.toIndentedString(this.counterpartyDateOfBirth)).append("\n");
        sb.append("    counterpartyAddress: ").append(this.toIndentedString(this.counterpartyAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

