/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="PaymentInitiationPaymentTokenCreateResponse defines the response schema for `/payment_initiation/payment/token/create`")
public class PaymentInitiationPaymentTokenCreateResponse {
    public static final String SERIALIZED_NAME_PAYMENT_TOKEN = "payment_token";
    @SerializedName(value="payment_token")
    private String paymentToken;
    public static final String SERIALIZED_NAME_PAYMENT_TOKEN_EXPIRATION_TIME = "payment_token_expiration_time";
    @SerializedName(value="payment_token_expiration_time")
    private OffsetDateTime paymentTokenExpirationTime;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public PaymentInitiationPaymentTokenCreateResponse paymentToken(String paymentToken) {
        this.paymentToken = paymentToken;
        return this;
    }

    @ApiModelProperty(required=true, value="A `payment_token` that can be provided to Link initialization to enter the payment initiation flow")
    public String getPaymentToken() {
        return this.paymentToken;
    }

    public void setPaymentToken(String paymentToken) {
        this.paymentToken = paymentToken;
    }

    public PaymentInitiationPaymentTokenCreateResponse paymentTokenExpirationTime(OffsetDateTime paymentTokenExpirationTime) {
        this.paymentTokenExpirationTime = paymentTokenExpirationTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time at which the token will expire, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format. A `payment_token` expires after 15 minutes.")
    public OffsetDateTime getPaymentTokenExpirationTime() {
        return this.paymentTokenExpirationTime;
    }

    public void setPaymentTokenExpirationTime(OffsetDateTime paymentTokenExpirationTime) {
        this.paymentTokenExpirationTime = paymentTokenExpirationTime;
    }

    public PaymentInitiationPaymentTokenCreateResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationPaymentTokenCreateResponse paymentInitiationPaymentTokenCreateResponse = (PaymentInitiationPaymentTokenCreateResponse)o;
        return Objects.equals(this.paymentToken, paymentInitiationPaymentTokenCreateResponse.paymentToken) && Objects.equals(this.paymentTokenExpirationTime, paymentInitiationPaymentTokenCreateResponse.paymentTokenExpirationTime) && Objects.equals(this.requestId, paymentInitiationPaymentTokenCreateResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.paymentToken, this.paymentTokenExpirationTime, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationPaymentTokenCreateResponse {\n");
        sb.append("    paymentToken: ").append(this.toIndentedString(this.paymentToken)).append("\n");
        sb.append("    paymentTokenExpirationTime: ").append(this.toIndentedString(this.paymentTokenExpirationTime)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

