/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaymentInitiationAddress;
import com.plaid.client.model.RecipientBACSNullable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PaymentInitiationRecipient defines a payment initiation recipient")
public class PaymentInitiationRecipient {
    public static final String SERIALIZED_NAME_RECIPIENT_ID = "recipient_id";
    @SerializedName(value="recipient_id")
    private String recipientId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private PaymentInitiationAddress address;
    public static final String SERIALIZED_NAME_IBAN = "iban";
    @SerializedName(value="iban")
    private String iban;
    public static final String SERIALIZED_NAME_BACS = "bacs";
    @SerializedName(value="bacs")
    private RecipientBACSNullable bacs;

    public PaymentInitiationRecipient recipientId(String recipientId) {
        this.recipientId = recipientId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the recipient.")
    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public PaymentInitiationRecipient name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the recipient.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PaymentInitiationRecipient address(PaymentInitiationAddress address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentInitiationAddress getAddress() {
        return this.address;
    }

    public void setAddress(PaymentInitiationAddress address) {
        this.address = address;
    }

    public PaymentInitiationRecipient iban(String iban) {
        this.iban = iban;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The International Bank Account Number (IBAN) for the recipient.")
    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public PaymentInitiationRecipient bacs(RecipientBACSNullable bacs) {
        this.bacs = bacs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public RecipientBACSNullable getBacs() {
        return this.bacs;
    }

    public void setBacs(RecipientBACSNullable bacs) {
        this.bacs = bacs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationRecipient paymentInitiationRecipient = (PaymentInitiationRecipient)o;
        return Objects.equals(this.recipientId, paymentInitiationRecipient.recipientId) && Objects.equals(this.name, paymentInitiationRecipient.name) && Objects.equals(this.address, paymentInitiationRecipient.address) && Objects.equals(this.iban, paymentInitiationRecipient.iban) && Objects.equals(this.bacs, paymentInitiationRecipient.bacs);
    }

    public int hashCode() {
        return Objects.hash(this.recipientId, this.name, this.address, this.iban, this.bacs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationRecipient {\n");
        sb.append("    recipientId: ").append(this.toIndentedString(this.recipientId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    bacs: ").append(this.toIndentedString(this.bacs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

