/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaymentInitiationAddress;
import com.plaid.client.model.RecipientBACSNullable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PaymentInitiationRecipientCreateRequest defines the request schema for `/payment_initiation/recipient/create`")
public class PaymentInitiationRecipientCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_IBAN = "iban";
    @SerializedName(value="iban")
    private String iban;
    public static final String SERIALIZED_NAME_BACS = "bacs";
    @SerializedName(value="bacs")
    private RecipientBACSNullable bacs;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private PaymentInitiationAddress address;

    public PaymentInitiationRecipientCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public PaymentInitiationRecipientCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public PaymentInitiationRecipientCreateRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the recipient. We recommend using strings of length 18 or less and avoid special characters to ensure compatibility with all institutions.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PaymentInitiationRecipientCreateRequest iban(String iban) {
        this.iban = iban;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The International Bank Account Number (IBAN) for the recipient. If BACS data is not provided, an IBAN is required.")
    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public PaymentInitiationRecipientCreateRequest bacs(RecipientBACSNullable bacs) {
        this.bacs = bacs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public RecipientBACSNullable getBacs() {
        return this.bacs;
    }

    public void setBacs(RecipientBACSNullable bacs) {
        this.bacs = bacs;
    }

    public PaymentInitiationRecipientCreateRequest address(PaymentInitiationAddress address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentInitiationAddress getAddress() {
        return this.address;
    }

    public void setAddress(PaymentInitiationAddress address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationRecipientCreateRequest paymentInitiationRecipientCreateRequest = (PaymentInitiationRecipientCreateRequest)o;
        return Objects.equals(this.clientId, paymentInitiationRecipientCreateRequest.clientId) && Objects.equals(this.secret, paymentInitiationRecipientCreateRequest.secret) && Objects.equals(this.name, paymentInitiationRecipientCreateRequest.name) && Objects.equals(this.iban, paymentInitiationRecipientCreateRequest.iban) && Objects.equals(this.bacs, paymentInitiationRecipientCreateRequest.bacs) && Objects.equals(this.address, paymentInitiationRecipientCreateRequest.address);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.name, this.iban, this.bacs, this.address);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationRecipientCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    bacs: ").append(this.toIndentedString(this.bacs)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

