/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaymentScheduleInterval;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Metadata specifically related to valid Payment Initiation standing order configurations for the institution.")
public class PaymentInitiationStandingOrderMetadata {
    public static final String SERIALIZED_NAME_SUPPORTS_STANDING_ORDER_END_DATE = "supports_standing_order_end_date";
    @SerializedName(value="supports_standing_order_end_date")
    private Boolean supportsStandingOrderEndDate;
    public static final String SERIALIZED_NAME_SUPPORTS_STANDING_ORDER_NEGATIVE_EXECUTION_DAYS = "supports_standing_order_negative_execution_days";
    @SerializedName(value="supports_standing_order_negative_execution_days")
    private Boolean supportsStandingOrderNegativeExecutionDays;
    public static final String SERIALIZED_NAME_VALID_STANDING_ORDER_INTERVALS = "valid_standing_order_intervals";
    @SerializedName(value="valid_standing_order_intervals")
    private List<PaymentScheduleInterval> validStandingOrderIntervals = new ArrayList<PaymentScheduleInterval>();

    public PaymentInitiationStandingOrderMetadata supportsStandingOrderEndDate(Boolean supportsStandingOrderEndDate) {
        this.supportsStandingOrderEndDate = supportsStandingOrderEndDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the institution supports closed-ended standing orders by providing an end date.")
    public Boolean getSupportsStandingOrderEndDate() {
        return this.supportsStandingOrderEndDate;
    }

    public void setSupportsStandingOrderEndDate(Boolean supportsStandingOrderEndDate) {
        this.supportsStandingOrderEndDate = supportsStandingOrderEndDate;
    }

    public PaymentInitiationStandingOrderMetadata supportsStandingOrderNegativeExecutionDays(Boolean supportsStandingOrderNegativeExecutionDays) {
        this.supportsStandingOrderNegativeExecutionDays = supportsStandingOrderNegativeExecutionDays;
        return this;
    }

    @ApiModelProperty(required=true, value="This is only applicable to `MONTHLY` standing orders. Indicates whether the institution supports negative integers (-1 to -5) for setting up a `MONTHLY` standing order relative to the end of the month.")
    public Boolean getSupportsStandingOrderNegativeExecutionDays() {
        return this.supportsStandingOrderNegativeExecutionDays;
    }

    public void setSupportsStandingOrderNegativeExecutionDays(Boolean supportsStandingOrderNegativeExecutionDays) {
        this.supportsStandingOrderNegativeExecutionDays = supportsStandingOrderNegativeExecutionDays;
    }

    public PaymentInitiationStandingOrderMetadata validStandingOrderIntervals(List<PaymentScheduleInterval> validStandingOrderIntervals) {
        this.validStandingOrderIntervals = validStandingOrderIntervals;
        return this;
    }

    public PaymentInitiationStandingOrderMetadata addValidStandingOrderIntervalsItem(PaymentScheduleInterval validStandingOrderIntervalsItem) {
        this.validStandingOrderIntervals.add(validStandingOrderIntervalsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of the valid standing order intervals supported by the institution.")
    public List<PaymentScheduleInterval> getValidStandingOrderIntervals() {
        return this.validStandingOrderIntervals;
    }

    public void setValidStandingOrderIntervals(List<PaymentScheduleInterval> validStandingOrderIntervals) {
        this.validStandingOrderIntervals = validStandingOrderIntervals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationStandingOrderMetadata paymentInitiationStandingOrderMetadata = (PaymentInitiationStandingOrderMetadata)o;
        return Objects.equals(this.supportsStandingOrderEndDate, paymentInitiationStandingOrderMetadata.supportsStandingOrderEndDate) && Objects.equals(this.supportsStandingOrderNegativeExecutionDays, paymentInitiationStandingOrderMetadata.supportsStandingOrderNegativeExecutionDays) && Objects.equals(this.validStandingOrderIntervals, paymentInitiationStandingOrderMetadata.validStandingOrderIntervals);
    }

    public int hashCode() {
        return Objects.hash(this.supportsStandingOrderEndDate, this.supportsStandingOrderNegativeExecutionDays, this.validStandingOrderIntervals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationStandingOrderMetadata {\n");
        sb.append("    supportsStandingOrderEndDate: ").append(this.toIndentedString(this.supportsStandingOrderEndDate)).append("\n");
        sb.append("    supportsStandingOrderNegativeExecutionDays: ").append(this.toIndentedString(this.supportsStandingOrderNegativeExecutionDays)).append("\n");
        sb.append("    validStandingOrderIntervals: ").append(this.toIndentedString(this.validStandingOrderIntervals)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

