/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Transaction information specific to inter-bank transfers. If the transaction was not an inter-bank transfer, all fields will be `null`.  If the `transactions` object was returned by a Transactions endpoint such as `/transactions/sync` or `/transactions/get`, the `payment_meta` key will always appear, but no data elements are guaranteed. If the `transactions` object was returned by an Assets endpoint such as `/asset_report/get/` or `/asset_report/pdf/get`, this field will only appear in an Asset Report with Insights.")
public class PaymentMeta {
    public static final String SERIALIZED_NAME_REFERENCE_NUMBER = "reference_number";
    @SerializedName(value="reference_number")
    private String referenceNumber;
    public static final String SERIALIZED_NAME_PPD_ID = "ppd_id";
    @SerializedName(value="ppd_id")
    private String ppdId;
    public static final String SERIALIZED_NAME_PAYEE = "payee";
    @SerializedName(value="payee")
    private String payee;
    public static final String SERIALIZED_NAME_BY_ORDER_OF = "by_order_of";
    @SerializedName(value="by_order_of")
    private String byOrderOf;
    public static final String SERIALIZED_NAME_PAYER = "payer";
    @SerializedName(value="payer")
    private String payer;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD = "payment_method";
    @SerializedName(value="payment_method")
    private String paymentMethod;
    public static final String SERIALIZED_NAME_PAYMENT_PROCESSOR = "payment_processor";
    @SerializedName(value="payment_processor")
    private String paymentProcessor;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;

    public PaymentMeta referenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The transaction reference number supplied by the financial institution.")
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public PaymentMeta ppdId(String ppdId) {
        this.ppdId = ppdId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ACH PPD ID for the payer.")
    public String getPpdId() {
        return this.ppdId;
    }

    public void setPpdId(String ppdId) {
        this.ppdId = ppdId;
    }

    public PaymentMeta payee(String payee) {
        this.payee = payee;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="For transfers, the party that is receiving the transaction.")
    public String getPayee() {
        return this.payee;
    }

    public void setPayee(String payee) {
        this.payee = payee;
    }

    public PaymentMeta byOrderOf(String byOrderOf) {
        this.byOrderOf = byOrderOf;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The party initiating a wire transfer. Will be `null` if the transaction is not a wire transfer.")
    public String getByOrderOf() {
        return this.byOrderOf;
    }

    public void setByOrderOf(String byOrderOf) {
        this.byOrderOf = byOrderOf;
    }

    public PaymentMeta payer(String payer) {
        this.payer = payer;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="For transfers, the party that is paying the transaction.")
    public String getPayer() {
        return this.payer;
    }

    public void setPayer(String payer) {
        this.payer = payer;
    }

    public PaymentMeta paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The type of transfer, e.g. 'ACH'")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public PaymentMeta paymentProcessor(String paymentProcessor) {
        this.paymentProcessor = paymentProcessor;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The name of the payment processor")
    public String getPaymentProcessor() {
        return this.paymentProcessor;
    }

    public void setPaymentProcessor(String paymentProcessor) {
        this.paymentProcessor = paymentProcessor;
    }

    public PaymentMeta reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The payer-supplied description of the transfer.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMeta paymentMeta = (PaymentMeta)o;
        return Objects.equals(this.referenceNumber, paymentMeta.referenceNumber) && Objects.equals(this.ppdId, paymentMeta.ppdId) && Objects.equals(this.payee, paymentMeta.payee) && Objects.equals(this.byOrderOf, paymentMeta.byOrderOf) && Objects.equals(this.payer, paymentMeta.payer) && Objects.equals(this.paymentMethod, paymentMeta.paymentMethod) && Objects.equals(this.paymentProcessor, paymentMeta.paymentProcessor) && Objects.equals(this.reason, paymentMeta.reason);
    }

    public int hashCode() {
        return Objects.hash(this.referenceNumber, this.ppdId, this.payee, this.byOrderOf, this.payer, this.paymentMethod, this.paymentProcessor, this.reason);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMeta {\n");
        sb.append("    referenceNumber: ").append(this.toIndentedString(this.referenceNumber)).append("\n");
        sb.append("    ppdId: ").append(this.toIndentedString(this.ppdId)).append("\n");
        sb.append("    payee: ").append(this.toIndentedString(this.payee)).append("\n");
        sb.append("    byOrderOf: ").append(this.toIndentedString(this.byOrderOf)).append("\n");
        sb.append("    payer: ").append(this.toIndentedString(this.payer)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    paymentProcessor: ").append(this.toIndentedString(this.paymentProcessor)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

