/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaymentProfileStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PaymentProfileGetResponse defines the response schema for `/payment_profile/get`")
public class PaymentProfileGetResponse {
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_DELETED_AT = "deleted_at";
    @SerializedName(value="deleted_at")
    private OffsetDateTime deletedAt;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private PaymentProfileStatus status;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public PaymentProfileGetResponse updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(required=true, value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:mm:ssZ`) indicating the last time the given Payment Profile was updated at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public PaymentProfileGetResponse createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:mm:ssZ`) indicating the time the given Payment Profile was created at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public PaymentProfileGetResponse deletedAt(OffsetDateTime deletedAt) {
        this.deletedAt = deletedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:mm:ssZ`) indicating the time the given Payment Profile was deleted at. Always `null` if the Payment Profile has not been deleted")
    public OffsetDateTime getDeletedAt() {
        return this.deletedAt;
    }

    public void setDeletedAt(OffsetDateTime deletedAt) {
        this.deletedAt = deletedAt;
    }

    public PaymentProfileGetResponse status(PaymentProfileStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PaymentProfileStatus getStatus() {
        return this.status;
    }

    public void setStatus(PaymentProfileStatus status) {
        this.status = status;
    }

    public PaymentProfileGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentProfileGetResponse paymentProfileGetResponse = (PaymentProfileGetResponse)o;
        return Objects.equals(this.updatedAt, paymentProfileGetResponse.updatedAt) && Objects.equals(this.createdAt, paymentProfileGetResponse.createdAt) && Objects.equals(this.deletedAt, paymentProfileGetResponse.deletedAt) && Objects.equals((Object)this.status, (Object)paymentProfileGetResponse.status) && Objects.equals(this.requestId, paymentProfileGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.updatedAt, this.createdAt, this.deletedAt, this.status, this.requestId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentProfileGetResponse {\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    deletedAt: ").append(this.toIndentedString(this.deletedAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

