/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PaymentProfileRemoveRequest defines the request schema for `/payment_profile/remove`")
public class PaymentProfileRemoveRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_PAYMENT_PROFILE_TOKEN = "payment_profile_token";
    @SerializedName(value="payment_profile_token")
    private String paymentProfileToken;

    public PaymentProfileRemoveRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public PaymentProfileRemoveRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public PaymentProfileRemoveRequest paymentProfileToken(String paymentProfileToken) {
        this.paymentProfileToken = paymentProfileToken;
        return this;
    }

    @ApiModelProperty(required=true, value="A payment profile token associated with the Payment Profile data that is being requested.")
    public String getPaymentProfileToken() {
        return this.paymentProfileToken;
    }

    public void setPaymentProfileToken(String paymentProfileToken) {
        this.paymentProfileToken = paymentProfileToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentProfileRemoveRequest paymentProfileRemoveRequest = (PaymentProfileRemoveRequest)o;
        return Objects.equals(this.clientId, paymentProfileRemoveRequest.clientId) && Objects.equals(this.secret, paymentProfileRemoveRequest.secret) && Objects.equals(this.paymentProfileToken, paymentProfileRemoveRequest.paymentProfileToken);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.paymentProfileToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentProfileRemoveRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    paymentProfileToken: ").append(this.toIndentedString(this.paymentProfileToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

