/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaymentInitiationPaymentStatus;
import com.plaid.client.model.PlaidError;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fired when the status of a payment has changed.")
public class PaymentStatusUpdateWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_PAYMENT_ID = "payment_id";
    @SerializedName(value="payment_id")
    private String paymentId;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transaction_id";
    @SerializedName(value="transaction_id")
    private String transactionId;
    public static final String SERIALIZED_NAME_NEW_PAYMENT_STATUS = "new_payment_status";
    @SerializedName(value="new_payment_status")
    private PaymentInitiationPaymentStatus newPaymentStatus;
    public static final String SERIALIZED_NAME_OLD_PAYMENT_STATUS = "old_payment_status";
    @SerializedName(value="old_payment_status")
    private PaymentInitiationPaymentStatus oldPaymentStatus;
    public static final String SERIALIZED_NAME_ORIGINAL_REFERENCE = "original_reference";
    @SerializedName(value="original_reference")
    private String originalReference;
    public static final String SERIALIZED_NAME_ADJUSTED_REFERENCE = "adjusted_reference";
    @SerializedName(value="adjusted_reference")
    private String adjustedReference;
    public static final String SERIALIZED_NAME_ORIGINAL_START_DATE = "original_start_date";
    @SerializedName(value="original_start_date")
    private LocalDate originalStartDate;
    public static final String SERIALIZED_NAME_ADJUSTED_START_DATE = "adjusted_start_date";
    @SerializedName(value="adjusted_start_date")
    private LocalDate adjustedStartDate;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private OffsetDateTime timestamp;
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private PlaidError error;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public PaymentStatusUpdateWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`PAYMENT_INITIATION`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public PaymentStatusUpdateWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`PAYMENT_STATUS_UPDATE`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public PaymentStatusUpdateWebhook paymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `payment_id` for the payment being updated")
    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public PaymentStatusUpdateWebhook transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The transaction ID that this payment is associated with, if any. This is present only when a payment was initiated using virtual accounts.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public PaymentStatusUpdateWebhook newPaymentStatus(PaymentInitiationPaymentStatus newPaymentStatus) {
        this.newPaymentStatus = newPaymentStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PaymentInitiationPaymentStatus getNewPaymentStatus() {
        return this.newPaymentStatus;
    }

    public void setNewPaymentStatus(PaymentInitiationPaymentStatus newPaymentStatus) {
        this.newPaymentStatus = newPaymentStatus;
    }

    public PaymentStatusUpdateWebhook oldPaymentStatus(PaymentInitiationPaymentStatus oldPaymentStatus) {
        this.oldPaymentStatus = oldPaymentStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PaymentInitiationPaymentStatus getOldPaymentStatus() {
        return this.oldPaymentStatus;
    }

    public void setOldPaymentStatus(PaymentInitiationPaymentStatus oldPaymentStatus) {
        this.oldPaymentStatus = oldPaymentStatus;
    }

    public PaymentStatusUpdateWebhook originalReference(String originalReference) {
        this.originalReference = originalReference;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The original value of the reference when creating the payment.")
    public String getOriginalReference() {
        return this.originalReference;
    }

    public void setOriginalReference(String originalReference) {
        this.originalReference = originalReference;
    }

    public PaymentStatusUpdateWebhook adjustedReference(String adjustedReference) {
        this.adjustedReference = adjustedReference;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The value of the reference sent to the bank after adjustment to pass bank validation rules.")
    public String getAdjustedReference() {
        return this.adjustedReference;
    }

    public void setAdjustedReference(String adjustedReference) {
        this.adjustedReference = adjustedReference;
    }

    public PaymentStatusUpdateWebhook originalStartDate(LocalDate originalStartDate) {
        this.originalStartDate = originalStartDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The original value of the `start_date` provided during the creation of a standing order. If the payment is not a standing order, this field will be `null`.")
    public LocalDate getOriginalStartDate() {
        return this.originalStartDate;
    }

    public void setOriginalStartDate(LocalDate originalStartDate) {
        this.originalStartDate = originalStartDate;
    }

    public PaymentStatusUpdateWebhook adjustedStartDate(LocalDate adjustedStartDate) {
        this.adjustedStartDate = adjustedStartDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The start date sent to the bank after adjusting for holidays or weekends.  Will be provided in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). If the start date did not require adjustment, or if the payment is not a standing order, this field will be `null`.")
    public LocalDate getAdjustedStartDate() {
        return this.adjustedStartDate;
    }

    public void setAdjustedStartDate(LocalDate adjustedStartDate) {
        this.adjustedStartDate = adjustedStartDate;
    }

    public PaymentStatusUpdateWebhook timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="The timestamp of the update, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format, e.g. `\"2017-09-14T14:42:19.350Z\"`")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public PaymentStatusUpdateWebhook error(PlaidError error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PlaidError getError() {
        return this.error;
    }

    public void setError(PlaidError error) {
        this.error = error;
    }

    public PaymentStatusUpdateWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentStatusUpdateWebhook paymentStatusUpdateWebhook = (PaymentStatusUpdateWebhook)o;
        return Objects.equals(this.webhookType, paymentStatusUpdateWebhook.webhookType) && Objects.equals(this.webhookCode, paymentStatusUpdateWebhook.webhookCode) && Objects.equals(this.paymentId, paymentStatusUpdateWebhook.paymentId) && Objects.equals(this.transactionId, paymentStatusUpdateWebhook.transactionId) && Objects.equals((Object)this.newPaymentStatus, (Object)paymentStatusUpdateWebhook.newPaymentStatus) && Objects.equals((Object)this.oldPaymentStatus, (Object)paymentStatusUpdateWebhook.oldPaymentStatus) && Objects.equals(this.originalReference, paymentStatusUpdateWebhook.originalReference) && Objects.equals(this.adjustedReference, paymentStatusUpdateWebhook.adjustedReference) && Objects.equals(this.originalStartDate, paymentStatusUpdateWebhook.originalStartDate) && Objects.equals(this.adjustedStartDate, paymentStatusUpdateWebhook.adjustedStartDate) && Objects.equals(this.timestamp, paymentStatusUpdateWebhook.timestamp) && Objects.equals(this.error, paymentStatusUpdateWebhook.error) && Objects.equals((Object)this.environment, (Object)paymentStatusUpdateWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.paymentId, this.transactionId, this.newPaymentStatus, this.oldPaymentStatus, this.originalReference, this.adjustedReference, this.originalStartDate, this.adjustedStartDate, this.timestamp, this.error, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentStatusUpdateWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    newPaymentStatus: ").append(this.toIndentedString((Object)this.newPaymentStatus)).append("\n");
        sb.append("    oldPaymentStatus: ").append(this.toIndentedString((Object)this.oldPaymentStatus)).append("\n");
        sb.append("    originalReference: ").append(this.toIndentedString(this.originalReference)).append("\n");
        sb.append("    adjustedReference: ").append(this.toIndentedString(this.adjustedReference)).append("\n");
        sb.append("    originalStartDate: ").append(this.toIndentedString(this.originalStartDate)).append("\n");
        sb.append("    adjustedStartDate: ").append(this.toIndentedString(this.adjustedStartDate)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

