/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PayrollIncomeRateOfPay;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object containing account level data.")
public class PayrollIncomeAccountData {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_RATE_OF_PAY = "rate_of_pay";
    @SerializedName(value="rate_of_pay")
    private PayrollIncomeRateOfPay rateOfPay;
    public static final String SERIALIZED_NAME_PAY_FREQUENCY = "pay_frequency";
    @SerializedName(value="pay_frequency")
    private String payFrequency;

    public PayrollIncomeAccountData accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="ID of the payroll provider account.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public PayrollIncomeAccountData rateOfPay(PayrollIncomeRateOfPay rateOfPay) {
        this.rateOfPay = rateOfPay;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PayrollIncomeRateOfPay getRateOfPay() {
        return this.rateOfPay;
    }

    public void setRateOfPay(PayrollIncomeRateOfPay rateOfPay) {
        this.rateOfPay = rateOfPay;
    }

    public PayrollIncomeAccountData payFrequency(String payFrequency) {
        this.payFrequency = payFrequency;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The frequency at which an individual is paid.")
    public String getPayFrequency() {
        return this.payFrequency;
    }

    public void setPayFrequency(String payFrequency) {
        this.payFrequency = payFrequency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayrollIncomeAccountData payrollIncomeAccountData = (PayrollIncomeAccountData)o;
        return Objects.equals(this.accountId, payrollIncomeAccountData.accountId) && Objects.equals(this.rateOfPay, payrollIncomeAccountData.rateOfPay) && Objects.equals(this.payFrequency, payrollIncomeAccountData.payFrequency);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.rateOfPay, this.payFrequency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayrollIncomeAccountData {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    rateOfPay: ").append(this.toIndentedString(this.rateOfPay)).append("\n");
        sb.append("    payFrequency: ").append(this.toIndentedString(this.payFrequency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

