/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Credit1099;
import com.plaid.client.model.CreditPayStub;
import com.plaid.client.model.CreditW2;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing payroll data.")
public class PayrollIncomeObject {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_PAY_STUBS = "pay_stubs";
    @SerializedName(value="pay_stubs")
    private List<CreditPayStub> payStubs = new ArrayList<CreditPayStub>();
    public static final String SERIALIZED_NAME_W2S = "w2s";
    @SerializedName(value="w2s")
    private List<CreditW2> w2s = new ArrayList<CreditW2>();
    public static final String SERIALIZED_NAME_FORM1099S = "form1099s";
    @SerializedName(value="form1099s")
    private List<Credit1099> form1099s = new ArrayList<Credit1099>();

    public PayrollIncomeObject accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="ID of the payroll provider account.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public PayrollIncomeObject payStubs(List<CreditPayStub> payStubs) {
        this.payStubs = payStubs;
        return this;
    }

    public PayrollIncomeObject addPayStubsItem(CreditPayStub payStubsItem) {
        this.payStubs.add(payStubsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of pay stubs for the user.")
    public List<CreditPayStub> getPayStubs() {
        return this.payStubs;
    }

    public void setPayStubs(List<CreditPayStub> payStubs) {
        this.payStubs = payStubs;
    }

    public PayrollIncomeObject w2s(List<CreditW2> w2s) {
        this.w2s = w2s;
        return this;
    }

    public PayrollIncomeObject addW2sItem(CreditW2 w2sItem) {
        this.w2s.add(w2sItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of tax form W-2s.")
    public List<CreditW2> getW2s() {
        return this.w2s;
    }

    public void setW2s(List<CreditW2> w2s) {
        this.w2s = w2s;
    }

    public PayrollIncomeObject form1099s(List<Credit1099> form1099s) {
        this.form1099s = form1099s;
        return this;
    }

    public PayrollIncomeObject addForm1099sItem(Credit1099 form1099sItem) {
        this.form1099s.add(form1099sItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of tax form 1099s.")
    public List<Credit1099> getForm1099s() {
        return this.form1099s;
    }

    public void setForm1099s(List<Credit1099> form1099s) {
        this.form1099s = form1099s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayrollIncomeObject payrollIncomeObject = (PayrollIncomeObject)o;
        return Objects.equals(this.accountId, payrollIncomeObject.accountId) && Objects.equals(this.payStubs, payrollIncomeObject.payStubs) && Objects.equals(this.w2s, payrollIncomeObject.w2s) && Objects.equals(this.form1099s, payrollIncomeObject.form1099s);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.payStubs, this.w2s, this.form1099s);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayrollIncomeObject {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    payStubs: ").append(this.toIndentedString(this.payStubs)).append("\n");
        sb.append("    w2s: ").append(this.toIndentedString(this.w2s)).append("\n");
        sb.append("    form1099s: ").append(this.toIndentedString(this.form1099s)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

