/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PayrollIncomeAccountData;
import com.plaid.client.model.PayrollIncomeObject;
import com.plaid.client.model.PayrollItemStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object containing information about the payroll item.")
public class PayrollItem {
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_INSTITUTION_NAME = "institution_name";
    @SerializedName(value="institution_name")
    private String institutionName;
    public static final String SERIALIZED_NAME_ACCOUNTS = "accounts";
    @SerializedName(value="accounts")
    private List<PayrollIncomeAccountData> accounts = new ArrayList<PayrollIncomeAccountData>();
    public static final String SERIALIZED_NAME_PAYROLL_INCOME = "payroll_income";
    @SerializedName(value="payroll_income")
    private List<PayrollIncomeObject> payrollIncome = new ArrayList<PayrollIncomeObject>();
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private PayrollItemStatus status;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;

    public PayrollItem itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `item_id` of the Item associated with this webhook, warning, or error")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public PayrollItem institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the institution associated with the Item.")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public PayrollItem institutionName(String institutionName) {
        this.institutionName = institutionName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the institution associated with the Item.")
    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public PayrollItem accounts(List<PayrollIncomeAccountData> accounts) {
        this.accounts = accounts;
        return this;
    }

    public PayrollItem addAccountsItem(PayrollIncomeAccountData accountsItem) {
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<PayrollIncomeAccountData> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<PayrollIncomeAccountData> accounts) {
        this.accounts = accounts;
    }

    public PayrollItem payrollIncome(List<PayrollIncomeObject> payrollIncome) {
        this.payrollIncome = payrollIncome;
        return this;
    }

    public PayrollItem addPayrollIncomeItem(PayrollIncomeObject payrollIncomeItem) {
        this.payrollIncome.add(payrollIncomeItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<PayrollIncomeObject> getPayrollIncome() {
        return this.payrollIncome;
    }

    public void setPayrollIncome(List<PayrollIncomeObject> payrollIncome) {
        this.payrollIncome = payrollIncome;
    }

    public PayrollItem status(PayrollItemStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public PayrollItemStatus getStatus() {
        return this.status;
    }

    public void setStatus(PayrollItemStatus status) {
        this.status = status;
    }

    public PayrollItem updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DDTHH:mm:ssZ) indicating the last time that the Item was updated.")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayrollItem payrollItem = (PayrollItem)o;
        return Objects.equals(this.itemId, payrollItem.itemId) && Objects.equals(this.institutionId, payrollItem.institutionId) && Objects.equals(this.institutionName, payrollItem.institutionName) && Objects.equals(this.accounts, payrollItem.accounts) && Objects.equals(this.payrollIncome, payrollItem.payrollIncome) && Objects.equals(this.status, payrollItem.status) && Objects.equals(this.updatedAt, payrollItem.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.institutionId, this.institutionName, this.accounts, this.payrollIncome, this.status, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayrollItem {\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    institutionName: ").append(this.toIndentedString(this.institutionName)).append("\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    payrollIncome: ").append(this.toIndentedString(this.payrollIncome)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

