/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Details about the status of the payroll item.")
public class PayrollItemStatus {
    public static final String SERIALIZED_NAME_PROCESSING_STATUS = "processing_status";
    @SerializedName(value="processing_status")
    private String processingStatus;

    public PayrollItemStatus processingStatus(String processingStatus) {
        this.processingStatus = processingStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Denotes the processing status for the verification.  `UNKNOWN`: The processing status could not be determined.  `PROCESSING_COMPLETE`: The processing has completed and the user has approved for sharing. The data is available to be retrieved.  `PROCESSING`: The verification is still processing. The data is not available yet.  `FAILED`: The processing failed to complete successfully.  `APPROVAL_STATUS_PENDING`: The processing has completed but the user has not yet approved the sharing of the data.")
    public String getProcessingStatus() {
        return this.processingStatus;
    }

    public void setProcessingStatus(String processingStatus) {
        this.processingStatus = processingStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayrollItemStatus payrollItemStatus = (PayrollItemStatus)o;
        return Objects.equals(this.processingStatus, payrollItemStatus.processingStatus);
    }

    public int hashCode() {
        return Objects.hash(this.processingStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayrollItemStatus {\n");
        sb.append("    processingStatus: ").append(this.toIndentedString(this.processingStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

