/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.DocumentRiskSignalsObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Object containing fraud risk data pertaining to the Item linked as part of the verification.")
public class PayrollRiskSignalsItem {
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_VERIFICATION_RISK_SIGNALS = "verification_risk_signals";
    @SerializedName(value="verification_risk_signals")
    private List<DocumentRiskSignalsObject> verificationRiskSignals = new ArrayList<DocumentRiskSignalsObject>();

    public PayrollRiskSignalsItem itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `item_id` of the Item associated with this webhook, warning, or error")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public PayrollRiskSignalsItem verificationRiskSignals(List<DocumentRiskSignalsObject> verificationRiskSignals) {
        this.verificationRiskSignals = verificationRiskSignals;
        return this;
    }

    public PayrollRiskSignalsItem addVerificationRiskSignalsItem(DocumentRiskSignalsObject verificationRiskSignalsItem) {
        this.verificationRiskSignals.add(verificationRiskSignalsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of payroll income document authenticity data retrieved for each of the user's accounts.")
    public List<DocumentRiskSignalsObject> getVerificationRiskSignals() {
        return this.verificationRiskSignals;
    }

    public void setVerificationRiskSignals(List<DocumentRiskSignalsObject> verificationRiskSignals) {
        this.verificationRiskSignals = verificationRiskSignals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayrollRiskSignalsItem payrollRiskSignalsItem = (PayrollRiskSignalsItem)o;
        return Objects.equals(this.itemId, payrollRiskSignalsItem.itemId) && Objects.equals(this.verificationRiskSignals, payrollRiskSignalsItem.verificationRiskSignals);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.verificationRiskSignals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayrollRiskSignalsItem {\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    verificationRiskSignals: ").append(this.toIndentedString(this.verificationRiskSignals)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

