/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Deductions;
import com.plaid.client.model.Earnings;
import com.plaid.client.model.Employee;
import com.plaid.client.model.EmploymentDetails;
import com.plaid.client.model.IncomeBreakdown;
import com.plaid.client.model.NetPay;
import com.plaid.client.model.PayPeriodDetails;
import com.plaid.client.model.PaystubDetails;
import com.plaid.client.model.PaystubEmployer;
import com.plaid.client.model.PaystubYTDDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing data extracted from the end user's paystub.")
public class Paystub {
    public static final String SERIALIZED_NAME_DEDUCTIONS = "deductions";
    @SerializedName(value="deductions")
    private Deductions deductions;
    public static final String SERIALIZED_NAME_DOC_ID = "doc_id";
    @SerializedName(value="doc_id")
    private String docId;
    public static final String SERIALIZED_NAME_EARNINGS = "earnings";
    @SerializedName(value="earnings")
    private Earnings earnings;
    public static final String SERIALIZED_NAME_EMPLOYEE = "employee";
    @SerializedName(value="employee")
    private Employee employee;
    public static final String SERIALIZED_NAME_EMPLOYER = "employer";
    @SerializedName(value="employer")
    private PaystubEmployer employer;
    public static final String SERIALIZED_NAME_EMPLOYMENT_DETAILS = "employment_details";
    @SerializedName(value="employment_details")
    private EmploymentDetails employmentDetails;
    public static final String SERIALIZED_NAME_NET_PAY = "net_pay";
    @SerializedName(value="net_pay")
    private NetPay netPay;
    public static final String SERIALIZED_NAME_PAY_PERIOD_DETAILS = "pay_period_details";
    @SerializedName(value="pay_period_details")
    private PayPeriodDetails payPeriodDetails;
    public static final String SERIALIZED_NAME_PAYSTUB_DETAILS = "paystub_details";
    @SerializedName(value="paystub_details")
    private PaystubDetails paystubDetails;
    public static final String SERIALIZED_NAME_INCOME_BREAKDOWN = "income_breakdown";
    @SerializedName(value="income_breakdown")
    private List<IncomeBreakdown> incomeBreakdown = null;
    public static final String SERIALIZED_NAME_YTD_EARNINGS = "ytd_earnings";
    @SerializedName(value="ytd_earnings")
    private PaystubYTDDetails ytdEarnings;

    public Paystub deductions(Deductions deductions) {
        this.deductions = deductions;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Deductions getDeductions() {
        return this.deductions;
    }

    public void setDeductions(Deductions deductions) {
        this.deductions = deductions;
    }

    public Paystub docId(String docId) {
        this.docId = docId;
        return this;
    }

    @ApiModelProperty(required=true, value="An identifier of the document referenced by the document metadata.")
    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public Paystub earnings(Earnings earnings) {
        this.earnings = earnings;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Earnings getEarnings() {
        return this.earnings;
    }

    public void setEarnings(Earnings earnings) {
        this.earnings = earnings;
    }

    public Paystub employee(Employee employee) {
        this.employee = employee;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public Paystub employer(PaystubEmployer employer) {
        this.employer = employer;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PaystubEmployer getEmployer() {
        return this.employer;
    }

    public void setEmployer(PaystubEmployer employer) {
        this.employer = employer;
    }

    public Paystub employmentDetails(EmploymentDetails employmentDetails) {
        this.employmentDetails = employmentDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EmploymentDetails getEmploymentDetails() {
        return this.employmentDetails;
    }

    public void setEmploymentDetails(EmploymentDetails employmentDetails) {
        this.employmentDetails = employmentDetails;
    }

    public Paystub netPay(NetPay netPay) {
        this.netPay = netPay;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public NetPay getNetPay() {
        return this.netPay;
    }

    public void setNetPay(NetPay netPay) {
        this.netPay = netPay;
    }

    public Paystub payPeriodDetails(PayPeriodDetails payPeriodDetails) {
        this.payPeriodDetails = payPeriodDetails;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PayPeriodDetails getPayPeriodDetails() {
        return this.payPeriodDetails;
    }

    public void setPayPeriodDetails(PayPeriodDetails payPeriodDetails) {
        this.payPeriodDetails = payPeriodDetails;
    }

    public Paystub paystubDetails(PaystubDetails paystubDetails) {
        this.paystubDetails = paystubDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaystubDetails getPaystubDetails() {
        return this.paystubDetails;
    }

    public void setPaystubDetails(PaystubDetails paystubDetails) {
        this.paystubDetails = paystubDetails;
    }

    public Paystub incomeBreakdown(List<IncomeBreakdown> incomeBreakdown) {
        this.incomeBreakdown = incomeBreakdown;
        return this;
    }

    public Paystub addIncomeBreakdownItem(IncomeBreakdown incomeBreakdownItem) {
        if (this.incomeBreakdown == null) {
            this.incomeBreakdown = new ArrayList<IncomeBreakdown>();
        }
        this.incomeBreakdown.add(incomeBreakdownItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<IncomeBreakdown> getIncomeBreakdown() {
        return this.incomeBreakdown;
    }

    public void setIncomeBreakdown(List<IncomeBreakdown> incomeBreakdown) {
        this.incomeBreakdown = incomeBreakdown;
    }

    public Paystub ytdEarnings(PaystubYTDDetails ytdEarnings) {
        this.ytdEarnings = ytdEarnings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaystubYTDDetails getYtdEarnings() {
        return this.ytdEarnings;
    }

    public void setYtdEarnings(PaystubYTDDetails ytdEarnings) {
        this.ytdEarnings = ytdEarnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Paystub paystub = (Paystub)o;
        return Objects.equals(this.deductions, paystub.deductions) && Objects.equals(this.docId, paystub.docId) && Objects.equals(this.earnings, paystub.earnings) && Objects.equals(this.employee, paystub.employee) && Objects.equals(this.employer, paystub.employer) && Objects.equals(this.employmentDetails, paystub.employmentDetails) && Objects.equals(this.netPay, paystub.netPay) && Objects.equals(this.payPeriodDetails, paystub.payPeriodDetails) && Objects.equals(this.paystubDetails, paystub.paystubDetails) && Objects.equals(this.incomeBreakdown, paystub.incomeBreakdown) && Objects.equals(this.ytdEarnings, paystub.ytdEarnings);
    }

    public int hashCode() {
        return Objects.hash(this.deductions, this.docId, this.earnings, this.employee, this.employer, this.employmentDetails, this.netPay, this.payPeriodDetails, this.paystubDetails, this.incomeBreakdown, this.ytdEarnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Paystub {\n");
        sb.append("    deductions: ").append(this.toIndentedString(this.deductions)).append("\n");
        sb.append("    docId: ").append(this.toIndentedString(this.docId)).append("\n");
        sb.append("    earnings: ").append(this.toIndentedString(this.earnings)).append("\n");
        sb.append("    employee: ").append(this.toIndentedString(this.employee)).append("\n");
        sb.append("    employer: ").append(this.toIndentedString(this.employer)).append("\n");
        sb.append("    employmentDetails: ").append(this.toIndentedString(this.employmentDetails)).append("\n");
        sb.append("    netPay: ").append(this.toIndentedString(this.netPay)).append("\n");
        sb.append("    payPeriodDetails: ").append(this.toIndentedString(this.payPeriodDetails)).append("\n");
        sb.append("    paystubDetails: ").append(this.toIndentedString(this.paystubDetails)).append("\n");
        sb.append("    incomeBreakdown: ").append(this.toIndentedString(this.incomeBreakdown)).append("\n");
        sb.append("    ytdEarnings: ").append(this.toIndentedString(this.ytdEarnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

