/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Address on the paystub")
public class PaystubAddress {
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
    @SerializedName(value="postal_code")
    private String postalCode;
    public static final String SERIALIZED_NAME_REGION = "region";
    @SerializedName(value="region")
    private String region;
    public static final String SERIALIZED_NAME_STREET = "street";
    @SerializedName(value="street")
    private String street;
    public static final String SERIALIZED_NAME_LINE1 = "line1";
    @SerializedName(value="line1")
    private String line1;
    public static final String SERIALIZED_NAME_LINE2 = "line2";
    @SerializedName(value="line2")
    private String line2;
    public static final String SERIALIZED_NAME_STATE_CODE = "state_code";
    @SerializedName(value="state_code")
    private String stateCode;

    public PaystubAddress city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The full city name.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public PaystubAddress country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO 3166-1 alpha-2 country code.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public PaystubAddress postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The postal code of the address.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public PaystubAddress region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The region or state Example: `\"NC\"`")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public PaystubAddress street(String street) {
        this.street = street;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The full street address.")
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public PaystubAddress line1(String line1) {
        this.line1 = line1;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Street address line 1.")
    public String getLine1() {
        return this.line1;
    }

    public void setLine1(String line1) {
        this.line1 = line1;
    }

    public PaystubAddress line2(String line2) {
        this.line2 = line2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Street address line 2.")
    public String getLine2() {
        return this.line2;
    }

    public void setLine2(String line2) {
        this.line2 = line2;
    }

    public PaystubAddress stateCode(String stateCode) {
        this.stateCode = stateCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The region or state Example: `\"NC\"`")
    public String getStateCode() {
        return this.stateCode;
    }

    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaystubAddress paystubAddress = (PaystubAddress)o;
        return Objects.equals(this.city, paystubAddress.city) && Objects.equals(this.country, paystubAddress.country) && Objects.equals(this.postalCode, paystubAddress.postalCode) && Objects.equals(this.region, paystubAddress.region) && Objects.equals(this.street, paystubAddress.street) && Objects.equals(this.line1, paystubAddress.line1) && Objects.equals(this.line2, paystubAddress.line2) && Objects.equals(this.stateCode, paystubAddress.stateCode);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.country, this.postalCode, this.region, this.street, this.line1, this.line2, this.stateCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaystubAddress {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    line1: ").append(this.toIndentedString(this.line1)).append("\n");
        sb.append("    line2: ").append(this.toIndentedString(this.line2)).append("\n");
        sb.append("    stateCode: ").append(this.toIndentedString(this.stateCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

