/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Deduction on the paystub")
public class PaystubDeduction {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_IS_PRETAX = "is_pretax";
    @SerializedName(value="is_pretax")
    private Boolean isPretax;
    public static final String SERIALIZED_NAME_TOTAL = "total";
    @SerializedName(value="total")
    private Double total;

    public PaystubDeduction type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The description of the deduction, as provided on the paystub. For example: `\"401(k)\"`, `\"FICA MED TAX\"`.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public PaystubDeduction isPretax(Boolean isPretax) {
        this.isPretax = isPretax;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="`true` if the deduction is pre-tax; `false` otherwise.")
    public Boolean getIsPretax() {
        return this.isPretax;
    }

    public void setIsPretax(Boolean isPretax) {
        this.isPretax = isPretax;
    }

    public PaystubDeduction total(Double total) {
        this.total = total;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The amount of the deduction.")
    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaystubDeduction paystubDeduction = (PaystubDeduction)o;
        return Objects.equals(this.type, paystubDeduction.type) && Objects.equals(this.isPretax, paystubDeduction.isPretax) && Objects.equals(this.total, paystubDeduction.total);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.isPretax, this.total);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaystubDeduction {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    isPretax: ").append(this.toIndentedString(this.isPretax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

