/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaystubPayFrequency;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing details that can be found on the paystub.")
public class PaystubDetails {
    public static final String SERIALIZED_NAME_PAY_PERIOD_START_DATE = "pay_period_start_date";
    @SerializedName(value="pay_period_start_date")
    private LocalDate payPeriodStartDate;
    public static final String SERIALIZED_NAME_PAY_PERIOD_END_DATE = "pay_period_end_date";
    @SerializedName(value="pay_period_end_date")
    private LocalDate payPeriodEndDate;
    public static final String SERIALIZED_NAME_PAY_DATE = "pay_date";
    @SerializedName(value="pay_date")
    private LocalDate payDate;
    public static final String SERIALIZED_NAME_PAYSTUB_PROVIDER = "paystub_provider";
    @SerializedName(value="paystub_provider")
    private String paystubProvider;
    public static final String SERIALIZED_NAME_PAY_FREQUENCY = "pay_frequency";
    @SerializedName(value="pay_frequency")
    private PaystubPayFrequency payFrequency;

    public PaystubDetails payPeriodStartDate(LocalDate payPeriodStartDate) {
        this.payPeriodStartDate = payPeriodStartDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Beginning date of the pay period on the paystub in the 'YYYY-MM-DD' format.")
    public LocalDate getPayPeriodStartDate() {
        return this.payPeriodStartDate;
    }

    public void setPayPeriodStartDate(LocalDate payPeriodStartDate) {
        this.payPeriodStartDate = payPeriodStartDate;
    }

    public PaystubDetails payPeriodEndDate(LocalDate payPeriodEndDate) {
        this.payPeriodEndDate = payPeriodEndDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Ending date of the pay period on the paystub in the 'YYYY-MM-DD' format.")
    public LocalDate getPayPeriodEndDate() {
        return this.payPeriodEndDate;
    }

    public void setPayPeriodEndDate(LocalDate payPeriodEndDate) {
        this.payPeriodEndDate = payPeriodEndDate;
    }

    public PaystubDetails payDate(LocalDate payDate) {
        this.payDate = payDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Pay date on the paystub in the 'YYYY-MM-DD' format.")
    public LocalDate getPayDate() {
        return this.payDate;
    }

    public void setPayDate(LocalDate payDate) {
        this.payDate = payDate;
    }

    public PaystubDetails paystubProvider(String paystubProvider) {
        this.paystubProvider = paystubProvider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the payroll provider that generated the paystub, e.g. ADP")
    public String getPaystubProvider() {
        return this.paystubProvider;
    }

    public void setPaystubProvider(String paystubProvider) {
        this.paystubProvider = paystubProvider;
    }

    public PaystubDetails payFrequency(PaystubPayFrequency payFrequency) {
        this.payFrequency = payFrequency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaystubPayFrequency getPayFrequency() {
        return this.payFrequency;
    }

    public void setPayFrequency(PaystubPayFrequency payFrequency) {
        this.payFrequency = payFrequency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaystubDetails paystubDetails = (PaystubDetails)o;
        return Objects.equals(this.payPeriodStartDate, paystubDetails.payPeriodStartDate) && Objects.equals(this.payPeriodEndDate, paystubDetails.payPeriodEndDate) && Objects.equals(this.payDate, paystubDetails.payDate) && Objects.equals(this.paystubProvider, paystubDetails.paystubProvider) && Objects.equals((Object)this.payFrequency, (Object)paystubDetails.payFrequency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.payPeriodStartDate, this.payPeriodEndDate, this.payDate, this.paystubProvider, this.payFrequency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaystubDetails {\n");
        sb.append("    payPeriodStartDate: ").append(this.toIndentedString(this.payPeriodStartDate)).append("\n");
        sb.append("    payPeriodEndDate: ").append(this.toIndentedString(this.payPeriodEndDate)).append("\n");
        sb.append("    payDate: ").append(this.toIndentedString(this.payDate)).append("\n");
        sb.append("    paystubProvider: ").append(this.toIndentedString(this.paystubProvider)).append("\n");
        sb.append("    payFrequency: ").append(this.toIndentedString((Object)this.payFrequency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

