/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing the total deductions for the pay period")
public class PaystubOverrideDeductionsTotal {
    public static final String SERIALIZED_NAME_CURRENT_AMOUNT = "current_amount";
    @SerializedName(value="current_amount")
    private Double currentAmount;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_YTD_AMOUNT = "ytd_amount";
    @SerializedName(value="ytd_amount")
    private Double ytdAmount;

    public PaystubOverrideDeductionsTotal currentAmount(Double currentAmount) {
        this.currentAmount = currentAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Raw amount of the deduction")
    public Double getCurrentAmount() {
        return this.currentAmount;
    }

    public void setCurrentAmount(Double currentAmount) {
        this.currentAmount = currentAmount;
    }

    public PaystubOverrideDeductionsTotal currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO-4217 currency code of the line item.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaystubOverrideDeductionsTotal ytdAmount(Double ytdAmount) {
        this.ytdAmount = ytdAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The year-to-date total amount of the deductions")
    public Double getYtdAmount() {
        return this.ytdAmount;
    }

    public void setYtdAmount(Double ytdAmount) {
        this.ytdAmount = ytdAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaystubOverrideDeductionsTotal paystubOverrideDeductionsTotal = (PaystubOverrideDeductionsTotal)o;
        return Objects.equals(this.currentAmount, paystubOverrideDeductionsTotal.currentAmount) && Objects.equals(this.currency, paystubOverrideDeductionsTotal.currency) && Objects.equals(this.ytdAmount, paystubOverrideDeductionsTotal.ytdAmount);
    }

    public int hashCode() {
        return Objects.hash(this.currentAmount, this.currency, this.ytdAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaystubOverrideDeductionsTotal {\n");
        sb.append("    currentAmount: ").append(this.toIndentedString(this.currentAmount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    ytdAmount: ").append(this.toIndentedString(this.ytdAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

