/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information about the accounts that the payment was distributed to.")
public class PaystubOverrideDistributionBreakdown {
    public static final String SERIALIZED_NAME_ACCOUNT_NAME = "account_name";
    @SerializedName(value="account_name")
    private String accountName;
    public static final String SERIALIZED_NAME_BANK_NAME = "bank_name";
    @SerializedName(value="bank_name")
    private String bankName;
    public static final String SERIALIZED_NAME_CURRENT_AMOUNT = "current_amount";
    @SerializedName(value="current_amount")
    private Double currentAmount;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_MASK = "mask";
    @SerializedName(value="mask")
    private String mask;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public PaystubOverrideDistributionBreakdown accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the account for the given distribution.")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public PaystubOverrideDistributionBreakdown bankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the bank that the payment is being deposited to.")
    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public PaystubOverrideDistributionBreakdown currentAmount(Double currentAmount) {
        this.currentAmount = currentAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount distributed to this account.")
    public Double getCurrentAmount() {
        return this.currentAmount;
    }

    public void setCurrentAmount(Double currentAmount) {
        this.currentAmount = currentAmount;
    }

    public PaystubOverrideDistributionBreakdown currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO-4217 currency code of the net pay. Always `null` if `unofficial_currency_code` is non-null.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaystubOverrideDistributionBreakdown mask(String mask) {
        this.mask = mask;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The last 2-4 alphanumeric characters of an account's official account number.")
    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public PaystubOverrideDistributionBreakdown type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of the account that the paystub was sent to (e.g. 'checking').")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaystubOverrideDistributionBreakdown paystubOverrideDistributionBreakdown = (PaystubOverrideDistributionBreakdown)o;
        return Objects.equals(this.accountName, paystubOverrideDistributionBreakdown.accountName) && Objects.equals(this.bankName, paystubOverrideDistributionBreakdown.bankName) && Objects.equals(this.currentAmount, paystubOverrideDistributionBreakdown.currentAmount) && Objects.equals(this.currency, paystubOverrideDistributionBreakdown.currency) && Objects.equals(this.mask, paystubOverrideDistributionBreakdown.mask) && Objects.equals(this.type, paystubOverrideDistributionBreakdown.type);
    }

    public int hashCode() {
        return Objects.hash(this.accountName, this.bankName, this.currentAmount, this.currency, this.mask, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaystubOverrideDistributionBreakdown {\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    bankName: ").append(this.toIndentedString(this.bankName)).append("\n");
        sb.append("    currentAmount: ").append(this.toIndentedString(this.currentAmount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    mask: ").append(this.toIndentedString(this.mask)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

