/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information describing the intent of the transaction. Most relevant for personal finance use cases, but not limited to such use cases.  See the [`taxonomy CSV file`](https://plaid.com/documents/transactions-personal-finance-category-taxonomy.csv) for a full list of personal finance categories. If you are migrating to personal finance categories from the legacy categories, also refer to the [`migration guide`](https://plaid.com/docs/transactions/pfc-migration/).")
public class PersonalFinanceCategory {
    public static final String SERIALIZED_NAME_PRIMARY = "primary";
    @SerializedName(value="primary")
    private String primary;
    public static final String SERIALIZED_NAME_DETAILED = "detailed";
    @SerializedName(value="detailed")
    private String detailed;
    public static final String SERIALIZED_NAME_CONFIDENCE_LEVEL = "confidence_level";
    @SerializedName(value="confidence_level")
    private String confidenceLevel;

    public PersonalFinanceCategory primary(String primary) {
        this.primary = primary;
        return this;
    }

    @ApiModelProperty(required=true, value="A high level category that communicates the broad category of the transaction.")
    public String getPrimary() {
        return this.primary;
    }

    public void setPrimary(String primary) {
        this.primary = primary;
    }

    public PersonalFinanceCategory detailed(String detailed) {
        this.detailed = detailed;
        return this;
    }

    @ApiModelProperty(required=true, value="A granular category conveying the transaction's intent. This field can also be used as a unique identifier for the category.")
    public String getDetailed() {
        return this.detailed;
    }

    public void setDetailed(String detailed) {
        this.detailed = detailed;
    }

    public PersonalFinanceCategory confidenceLevel(String confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A description of how confident we are that the provided categories accurately describe the transaction intent.  `VERY_HIGH`: We are more than 98% confident that this category reflects the intent of the transaction. `HIGH`: We are more than 90% confident that this category reflects the intent of the transaction. `MEDIUM`: We are moderately confident that this category reflects the intent of the transaction. `LOW`: This category may reflect the intent, but there may be other categories that are more accurate. `UNKNOWN`: We don\u2019t know the confidence level for this category.")
    public String getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public void setConfidenceLevel(String confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonalFinanceCategory personalFinanceCategory = (PersonalFinanceCategory)o;
        return Objects.equals(this.primary, personalFinanceCategory.primary) && Objects.equals(this.detailed, personalFinanceCategory.detailed) && Objects.equals(this.confidenceLevel, personalFinanceCategory.confidenceLevel);
    }

    public int hashCode() {
        return Objects.hash(this.primary, this.detailed, this.confidenceLevel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PersonalFinanceCategory {\n");
        sb.append("    primary: ").append(this.toIndentedString(this.primary)).append("\n");
        sb.append("    detailed: ").append(this.toIndentedString(this.detailed)).append("\n");
        sb.append("    confidenceLevel: ").append(this.toIndentedString(this.confidenceLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

