/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Score found by matching phone number provided by the API with the phone number on the account at the financial institution. 100 is a perfect match and 0 is a no match. If the account contains multiple owners, the maximum match score is filled.")
public class PhoneNumberMatchScore {
    public static final String SERIALIZED_NAME_SCORE = "score";
    @SerializedName(value="score")
    private Integer score;

    public PhoneNumberMatchScore score(Integer score) {
        this.score = score;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match score for normalized phone number. 100 is a perfect match, 99-70 is a partial match (matching the same phone number with extension against one without extension, etc.), anything below 70 is considered a mismatch. Typically, the match threshold should be set to a score of 70 or higher. If the phone number is missing from either the API or financial institution, this is null.")
    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumberMatchScore phoneNumberMatchScore = (PhoneNumberMatchScore)o;
        return Objects.equals(this.score, phoneNumberMatchScore.score);
    }

    public int hashCode() {
        return Objects.hash(this.score);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhoneNumberMatchScore {\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

