/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IdentityVerificationDocumentAddressResponse;
import com.plaid.client.model.PhysicalDocumentCategory;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Data extracted from a user-submitted document.")
public class PhysicalDocumentExtractedData {
    public static final String SERIALIZED_NAME_ID_NUMBER = "id_number";
    @SerializedName(value="id_number")
    private String idNumber;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private PhysicalDocumentCategory category;
    public static final String SERIALIZED_NAME_EXPIRATION_DATE = "expiration_date";
    @SerializedName(value="expiration_date")
    private LocalDate expirationDate;
    public static final String SERIALIZED_NAME_ISSUING_COUNTRY = "issuing_country";
    @SerializedName(value="issuing_country")
    private String issuingCountry;
    public static final String SERIALIZED_NAME_ISSUING_REGION = "issuing_region";
    @SerializedName(value="issuing_region")
    private String issuingRegion;
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "date_of_birth";
    @SerializedName(value="date_of_birth")
    private LocalDate dateOfBirth;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private IdentityVerificationDocumentAddressResponse address;

    public PhysicalDocumentExtractedData idNumber(String idNumber) {
        this.idNumber = idNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="AB123456", required=true, value="Alpha-numeric ID number extracted via OCR from the user's document image.")
    public String getIdNumber() {
        return this.idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public PhysicalDocumentExtractedData category(PhysicalDocumentCategory category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PhysicalDocumentCategory getCategory() {
        return this.category;
    }

    public void setCategory(PhysicalDocumentCategory category) {
        this.category = category;
    }

    public PhysicalDocumentExtractedData expirationDate(LocalDate expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Tue May 29 00:00:00 UTC 1990", required=true, value="A date in the format YYYY-MM-DD (RFC 3339 Section 5.6).")
    public LocalDate getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(LocalDate expirationDate) {
        this.expirationDate = expirationDate;
    }

    public PhysicalDocumentExtractedData issuingCountry(String issuingCountry) {
        this.issuingCountry = issuingCountry;
        return this;
    }

    @ApiModelProperty(example="US", required=true, value="Valid, capitalized, two-letter ISO code representing the country of this object. Must be in ISO 3166-1 alpha-2 form.")
    public String getIssuingCountry() {
        return this.issuingCountry;
    }

    public void setIssuingCountry(String issuingCountry) {
        this.issuingCountry = issuingCountry;
    }

    public PhysicalDocumentExtractedData issuingRegion(String issuingRegion) {
        this.issuingRegion = issuingRegion;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="IN", required=true, value="An ISO 3166-2 subdivision code. Related terms would be \"state\", \"province\", \"prefecture\", \"zone\", \"subdivision\", etc.")
    public String getIssuingRegion() {
        return this.issuingRegion;
    }

    public void setIssuingRegion(String issuingRegion) {
        this.issuingRegion = issuingRegion;
    }

    public PhysicalDocumentExtractedData dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Tue May 29 00:00:00 UTC 1990", required=true, value="A date extracted from the document in the format YYYY-MM-DD (RFC 3339 Section 5.6).")
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public PhysicalDocumentExtractedData address(IdentityVerificationDocumentAddressResponse address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public IdentityVerificationDocumentAddressResponse getAddress() {
        return this.address;
    }

    public void setAddress(IdentityVerificationDocumentAddressResponse address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalDocumentExtractedData physicalDocumentExtractedData = (PhysicalDocumentExtractedData)o;
        return Objects.equals(this.idNumber, physicalDocumentExtractedData.idNumber) && Objects.equals((Object)this.category, (Object)physicalDocumentExtractedData.category) && Objects.equals(this.expirationDate, physicalDocumentExtractedData.expirationDate) && Objects.equals(this.issuingCountry, physicalDocumentExtractedData.issuingCountry) && Objects.equals(this.issuingRegion, physicalDocumentExtractedData.issuingRegion) && Objects.equals(this.dateOfBirth, physicalDocumentExtractedData.dateOfBirth) && Objects.equals(this.address, physicalDocumentExtractedData.address);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.idNumber, this.category, this.expirationDate, this.issuingCountry, this.issuingRegion, this.dateOfBirth, this.address});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhysicalDocumentExtractedData {\n");
        sb.append("    idNumber: ").append(this.toIndentedString(this.idNumber)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    issuingCountry: ").append(this.toIndentedString(this.issuingCountry)).append("\n");
        sb.append("    issuingRegion: ").append(this.toIndentedString(this.issuingRegion)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

