/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="URLs for downloading original and cropped images for this document submission. The URLs are designed to only allow downloading, not hot linking, so the URL will only serve the document image for 60 seconds before expiring. The expiration time is 60 seconds after the `GET` request for the associated Identity Verification attempt. A new expiring URL is generated with each request, so you can always rerequest the Identity Verification attempt if one of your URLs expires.")
public class PhysicalDocumentImages {
    public static final String SERIALIZED_NAME_ORIGINAL_FRONT = "original_front";
    @SerializedName(value="original_front")
    private String originalFront;
    public static final String SERIALIZED_NAME_ORIGINAL_BACK = "original_back";
    @SerializedName(value="original_back")
    private String originalBack;
    public static final String SERIALIZED_NAME_CROPPED_FRONT = "cropped_front";
    @SerializedName(value="cropped_front")
    private String croppedFront;
    public static final String SERIALIZED_NAME_CROPPED_BACK = "cropped_back";
    @SerializedName(value="cropped_back")
    private String croppedBack;
    public static final String SERIALIZED_NAME_FACE = "face";
    @SerializedName(value="face")
    private String face;

    public PhysicalDocumentImages originalFront(String originalFront) {
        this.originalFront = originalFront;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://example.plaid.com/verifications/idv_52xR9LKo77r1Np/documents/1/original_front.jpeg", required=true, value="Temporary URL that expires after 60 seconds for downloading the uncropped original image of the front of the document.")
    public String getOriginalFront() {
        return this.originalFront;
    }

    public void setOriginalFront(String originalFront) {
        this.originalFront = originalFront;
    }

    public PhysicalDocumentImages originalBack(String originalBack) {
        this.originalBack = originalBack;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://example.plaid.com/verifications/idv_52xR9LKo77r1Np/documents/1/original_back.jpeg", required=true, value="Temporary URL that expires after 60 seconds for downloading the original image of the back of the document. Might be null if the back of the document was not collected.")
    public String getOriginalBack() {
        return this.originalBack;
    }

    public void setOriginalBack(String originalBack) {
        this.originalBack = originalBack;
    }

    public PhysicalDocumentImages croppedFront(String croppedFront) {
        this.croppedFront = croppedFront;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://example.plaid.com/verifications/idv_52xR9LKo77r1Np/documents/1/cropped_front.jpeg", required=true, value="Temporary URL that expires after 60 seconds for downloading a cropped image containing just the front of the document.")
    public String getCroppedFront() {
        return this.croppedFront;
    }

    public void setCroppedFront(String croppedFront) {
        this.croppedFront = croppedFront;
    }

    public PhysicalDocumentImages croppedBack(String croppedBack) {
        this.croppedBack = croppedBack;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://example.plaid.com/verifications/idv_52xR9LKo77r1Np/documents/1/cropped_back.jpeg", required=true, value="Temporary URL that expires after 60 seconds for downloading a cropped image containing just the back of the document. Might be null if the back of the document was not collected.")
    public String getCroppedBack() {
        return this.croppedBack;
    }

    public void setCroppedBack(String croppedBack) {
        this.croppedBack = croppedBack;
    }

    public PhysicalDocumentImages face(String face) {
        this.face = face;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://example.plaid.com/verifications/idv_52xR9LKo77r1Np/documents/1/face.jpeg", required=true, value="Temporary URL that expires after 60 seconds for downloading a crop of just the user's face from the document image. Might be null if the document does not contain a face photo.")
    public String getFace() {
        return this.face;
    }

    public void setFace(String face) {
        this.face = face;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalDocumentImages physicalDocumentImages = (PhysicalDocumentImages)o;
        return Objects.equals(this.originalFront, physicalDocumentImages.originalFront) && Objects.equals(this.originalBack, physicalDocumentImages.originalBack) && Objects.equals(this.croppedFront, physicalDocumentImages.croppedFront) && Objects.equals(this.croppedBack, physicalDocumentImages.croppedBack) && Objects.equals(this.face, physicalDocumentImages.face);
    }

    public int hashCode() {
        return Objects.hash(this.originalFront, this.originalBack, this.croppedFront, this.croppedBack, this.face);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhysicalDocumentImages {\n");
        sb.append("    originalFront: ").append(this.toIndentedString(this.originalFront)).append("\n");
        sb.append("    originalBack: ").append(this.toIndentedString(this.originalBack)).append("\n");
        sb.append("    croppedFront: ").append(this.toIndentedString(this.croppedFront)).append("\n");
        sb.append("    croppedBack: ").append(this.toIndentedString(this.croppedBack)).append("\n");
        sb.append("    face: ").append(this.toIndentedString(this.face)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

